/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command.params;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.check.CheckResult;
import org.oddlama.vane.core.command.check.ErrorCheckResult;
import org.oddlama.vane.core.command.check.ParseCheckResult;
import org.oddlama.vane.core.command.params.BaseParam;
import org.oddlama.vane.core.functional.Function1;

public class FixedParam<T>
extends BaseParam {
    private T fixed_arg;
    private String fixed_arg_str;
    private boolean include_param = false;
    private boolean ignore_case = false;

    public FixedParam(Command<?> command, T fixed_arg, Function1<T, String> to_string) {
        super(command);
        this.fixed_arg = fixed_arg;
        this.fixed_arg_str = to_string.apply(fixed_arg);
    }

    public FixedParam<T> ignore_case() {
        this.ignore_case = true;
        return this;
    }

    public FixedParam<T> include_param() {
        this.include_param = true;
        return this;
    }

    @Override
    public CheckResult check_parse(CommandSender sender, String[] args, int offset) {
        if (args.length <= offset) {
            return new ErrorCheckResult(offset, "\u00a76missing argument: \u00a73" + this.fixed_arg_str + "\u00a7r");
        }
        T parsed = this.parse(args[offset]);
        if (parsed == null) {
            return new ErrorCheckResult(offset, "\u00a76invalid argument: expected \u00a73" + this.fixed_arg_str + "\u00a76 got \u00a7b" + args[offset] + "\u00a7r");
        }
        return new ParseCheckResult(offset, this.fixed_arg_str, parsed, this.include_param);
    }

    @Override
    public List<String> completions_for(CommandSender sender, String[] args, int offset) {
        return Collections.singletonList(this.fixed_arg_str);
    }

    private T parse(String arg) {
        if (this.ignore_case ? arg.equalsIgnoreCase(this.fixed_arg_str) : arg.equals(this.fixed_arg_str)) {
            return this.fixed_arg;
        }
        return null;
    }
}

