/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.command.params;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.Executor;
import org.oddlama.vane.core.command.Param;
import org.oddlama.vane.core.command.check.CheckResult;
import org.oddlama.vane.core.command.check.ErrorCheckResult;
import org.oddlama.vane.core.command.check.ExecutorCheckResult;
import org.oddlama.vane.core.command.params.BaseParam;
import org.oddlama.vane.core.functional.ErasedFunctor;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.GenericsFinder;
import org.oddlama.vane.core.module.Module;

public class SentinelExecutorParam<T>
extends BaseParam
implements Executor {
    private T function;
    private Function1<CommandSender, Boolean> check_requirements;
    private Function1<Integer, Boolean> skip_argument_check;

    public SentinelExecutorParam(Command<?> command, T function) {
        this(command, function, x -> true);
    }

    public SentinelExecutorParam(Command<?> command, T function, Function1<CommandSender, Boolean> check_requirements) {
        this(command, function, check_requirements, i -> false);
    }

    public SentinelExecutorParam(Command<?> command, T function, Function1<CommandSender, Boolean> check_requirements, Function1<Integer, Boolean> skip_argument_check) {
        super(command);
        this.function = function;
        this.check_requirements = check_requirements;
        this.skip_argument_check = skip_argument_check;
    }

    private boolean check_signature(Method method, List<Object> args) {
        if (args.size() != method.getParameters().length) {
            throw new RuntimeException("Invalid command functor " + method.getDeclaringClass().getName() + "::" + method.getName() + "!\nFunctor takes " + method.getParameters().length + " parameters, but " + args.size() + " were given.\nRequired: " + String.valueOf(Arrays.stream(method.getParameters()).map(p -> p.getType().getName()).toList()) + "\nGiven: " + String.valueOf(args.stream().map(p -> p.getClass().getName()).toList()));
        }
        for (int i = 0; i < args.size(); ++i) {
            Class<?> got;
            Class<?> needs;
            if (this.skip_argument_check.apply(i).booleanValue() || (needs = method.getParameters()[i].getType()).isAssignableFrom(got = args.get(i).getClass())) continue;
            throw new RuntimeException("Invalid command functor " + method.getDeclaringClass().getName() + "::" + method.getName() + "!\nArgument " + (i + 1) + " (" + needs.getName() + ") is not assignable from " + got.getName());
        }
        return true;
    }

    @Override
    public boolean is_executor() {
        return true;
    }

    @Override
    public boolean execute(Command<?> command, CommandSender sender, List<Object> parsed_args) {
        parsed_args.set(0, sender);
        Logger log = ((Module)command.get_module()).core.log;
        Filter saved_filter = log.getFilter();
        log.setFilter(record -> false);
        GenericsFinder gf = (GenericsFinder)this.function;
        Method method = gf.method();
        log.setFilter(saved_filter);
        this.check_signature(method, parsed_args);
        if (!this.check_requirements.apply(sender).booleanValue()) {
            return false;
        }
        try {
            Object result = ((ErasedFunctor)this.function).invoke(parsed_args);
            return result == null || (Boolean)result != false;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while invoking functor " + method.getDeclaringClass().getName() + "::" + method.getName() + "!", e);
        }
    }

    @Override
    public void add_param(Param param) {
        throw new RuntimeException("Cannot add element to sentinel executor! This is a bug.");
    }

    @Override
    public CheckResult check_parse(CommandSender sender, String[] args, int offset) {
        return null;
    }

    @Override
    public List<String> completions_for(CommandSender sender, String[] args, int offset) {
        return Collections.emptyList();
    }

    @Override
    public CheckResult check_accept(CommandSender sender, String[] args, int offset) {
        if (args.length > offset) {
            return new ErrorCheckResult(offset - 1, "\u00a76excess arguments: {" + Arrays.stream(args, offset, args.length).map(s -> "\u00a74" + s + "\u00a76").collect(Collectors.joining(", ")) + "}\u00a7r");
        }
        if (args.length < offset) {
            throw new RuntimeException("Sentinel executor received missing arguments! This is a bug.");
        }
        return new ExecutorCheckResult(offset, this);
    }
}

