/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.oddlama.vane.annotation.command.Name;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.argumentType.EnchantmentFilterArgumentType;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;

@Name(value="enchant")
public class Enchant
extends Command<Core> {
    @LangMessage
    private TranslatedMessage lang_level_too_low;
    @LangMessage
    private TranslatedMessage lang_level_too_high;
    @LangMessage
    private TranslatedMessage lang_invalid_enchantment;

    public Enchant(Context<Core> context) {
        super(context);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> get_command_base() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)super.get_command_base().requires(ctx -> ctx.getSender() instanceof Player)).then(this.help())).then(((RequiredArgumentBuilder)Commands.argument((String)"enchantment", (ArgumentType)EnchantmentFilterArgumentType.enchantmentFilter()).executes(ctx -> {
            this.enchant_current_item_level_1((Player)((CommandSourceStack)ctx.getSource()).getSender(), this.enchantment((CommandContext<CommandSourceStack>)ctx));
            return 1;
        })).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            this.enchant_current_item((Player)((CommandSourceStack)ctx.getSource()).getSender(), this.enchantment((CommandContext<CommandSourceStack>)ctx), (Integer)ctx.getArgument("level", Integer.class));
            return 1;
        })));
    }

    private Enchantment enchantment(CommandContext<CommandSourceStack> ctx) {
        return (Enchantment)ctx.getArgument("enchantment", Enchantment.class);
    }

    private boolean filter_by_held_item(CommandSender sender, Enchantment e) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        ItemStack item_stack = player.getEquipment().getItemInMainHand();
        boolean is_book = item_stack.getType() == Material.BOOK || item_stack.getType() == Material.ENCHANTED_BOOK;
        return is_book || e.canEnchantItem(item_stack);
    }

    private void enchant_current_item_level_1(Player player, Enchantment enchantment) {
        this.enchant_current_item(player, enchantment, 1);
    }

    private void enchant_current_item(Player player, Enchantment enchantment, Integer level) {
        if (level < enchantment.getStartLevel()) {
            this.lang_level_too_low.send((CommandSender)player, "\u00a7b" + level, "\u00a7a" + enchantment.getStartLevel());
            return;
        }
        if (level > enchantment.getMaxLevel()) {
            this.lang_level_too_high.send((CommandSender)player, "\u00a7b" + level, "\u00a7a" + enchantment.getMaxLevel());
            return;
        }
        ItemStack item_stack = player.getEquipment().getItemInMainHand();
        if (item_stack.getType() == Material.AIR) {
            this.lang_invalid_enchantment.send((CommandSender)player, "\u00a7b" + String.valueOf(enchantment.getKey()), "\u00a7a" + String.valueOf(item_stack.getType().getKey()));
            return;
        }
        try {
            if (item_stack.getType() == Material.BOOK) {
                item_stack = item_stack.withType(Material.ENCHANTED_BOOK);
            }
            if (item_stack.getType() == Material.ENCHANTED_BOOK) {
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item_stack.getItemMeta();
                meta.addStoredEnchant(enchantment, level.intValue(), false);
                item_stack.setItemMeta((ItemMeta)meta);
            } else {
                item_stack.addEnchantment(enchantment, level.intValue());
            }
            ((Core)this.get_module()).enchantment_manager.update_enchanted_item(item_stack);
        }
        catch (Exception e) {
            this.lang_invalid_enchantment.send((CommandSender)player, "\u00a7b" + String.valueOf(enchantment.getKey()), "\u00a7a" + String.valueOf(item_stack.getType().getKey()));
        }
    }
}

