/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.File;
import java.util.List;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.LootTables;
import org.oddlama.vane.annotation.command.Name;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.command.Command;
import org.oddlama.vane.core.command.argumentType.ModuleArgumentType;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.resourcepack.ResourcePackDistributor;

@Name(value="vane")
public class Vane
extends Command<Core> {
    @LangMessage
    private TranslatedMessage lang_reload_success;
    @LangMessage
    private TranslatedMessage lang_reload_fail;
    @LangMessage
    private TranslatedMessage lang_resource_pack_generate_success;
    @LangMessage
    private TranslatedMessage lang_resource_pack_generate_fail;

    public Vane(Context<Core> context) {
        super(context);
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> get_command_base() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)super.get_command_base().then(this.help())).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").executes(ctx -> {
            this.reload_all(((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        })).then(Commands.argument((String)"module", (ArgumentType)ModuleArgumentType.module((Core)this.get_module())).executes(ctx -> {
            this.reload_module(((CommandSourceStack)ctx.getSource()).getSender(), (Module)ctx.getArgument("module", Module.class));
            return 1;
        })))).then(Commands.literal((String)"generate_resource_pack").executes(ctx -> {
            this.generate_resource_pack(((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        }))).then(Commands.literal((String)"test_do_not_use_if_you_are_not_a_dev").executes(ctx -> {
            this.test(((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        }));
    }

    private void reload_module(CommandSender sender, Module<?> module) {
        if (module.reload_configuration()) {
            this.lang_reload_success.send(sender, "\u00a7bvane-" + module.get_name());
        } else {
            this.lang_reload_fail.send(sender, "\u00a7bvane-" + module.get_name());
        }
    }

    private void reload_all(CommandSender sender) {
        for (Module module : ((Core)this.get_module()).core.get_modules()) {
            this.reload_module(sender, module);
        }
    }

    private void generate_resource_pack(CommandSender sender) {
        File file = ((Core)this.get_module()).generate_resource_pack();
        if (file != null) {
            this.lang_resource_pack_generate_success.send(sender, file.getAbsolutePath());
        } else {
            this.lang_resource_pack_generate_fail.send(sender, new Object[0]);
        }
        if (sender instanceof Player) {
            ResourcePackDistributor dist = ((Core)this.get_module()).resource_pack_distributor;
            dist.update_sha1(file);
            dist.send_resource_pack((Player)sender);
        }
    }

    private void test_tome_generation() {
        LootTable loot_table = LootTables.ABANDONED_MINESHAFT.getLootTable();
        Inventory inventory = ((Core)this.get_module()).getServer().createInventory(null, 27);
        LootContext context = new LootContext.Builder(((World)((Core)this.get_module()).getServer().getWorlds().get(0)).getBlockAt(0, 0, 0).getLocation()).build();
        Random random = new Random();
        int tomes = 0;
        int simulation_count = 10000;
        double gt_percentage = 0.2;
        double tolerance = 0.7;
        ((Core)this.get_module()).log.info("Testing ancient tome generation...");
        for (int i = 0; i < 10000; ++i) {
            inventory.clear();
            loot_table.fillInventory(inventory, random, context);
            for (ItemStack is : inventory.getStorageContents()) {
                List modelData;
                if (is == null || !is.hasItemMeta() || (modelData = is.getItemMeta().getCustomModelDataComponent().getFloats()).isEmpty() || ((Float)modelData.getFirst()).floatValue() != 7798784.0f) continue;
                ++tomes;
            }
        }
        if (tomes == 0) {
            ((Core)this.get_module()).log.severe("0 tomes were generated in 10000 chests.");
        } else if ((double)tomes > 1400.0 && (double)tomes < 2857.1428571428573) {
            ((Core)this.get_module()).log.warning(tomes + " tomes were generated in 10000 chests. This is " + 100.0 * ((double)tomes / 10000.0) / 0.2 + "% of the expected value.");
        } else {
            ((Core)this.get_module()).log.info(tomes + " tomes were generated in 10000 chests. This is " + 100.0 * ((double)tomes / 10000.0) / 0.2 + "% of the expected value.");
        }
    }

    private void test(CommandSender sender) {
        this.test_tome_generation();
    }
}

