/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigDict;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigDictSerializable;
import org.oddlama.vane.core.config.ConfigField;

public class ConfigDictField
extends ConfigField<ConfigDictSerializable> {
    public ConfigDict annotation;

    public ConfigDictField(Object owner, Field field, Function<String, String> map_name, ConfigDict annotation) {
        super(owner, field, map_name, "dict", annotation.desc());
        this.annotation = annotation;
    }

    @Override
    public ConfigDictSerializable def() {
        ConfigDictSerializable override = (ConfigDictSerializable)this.overridden_def();
        if (override != null) {
            return override;
        }
        return new EmptyDict(this);
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    private void append_list(StringBuilder builder, String indent, String list_key, List<Object> list) {
        builder.append(indent);
        builder.append(list_key);
        if (list.isEmpty()) {
            builder.append(": []\n");
        } else {
            builder.append(":\n");
            list.forEach(entry -> {
                if (entry instanceof String) {
                    builder.append(indent);
                    builder.append("  - ");
                    builder.append("\"" + this.escape_yaml(entry.toString()) + "\"");
                    builder.append("\n");
                } else if (entry instanceof Integer || entry instanceof Long || entry instanceof Float || entry instanceof Double || entry instanceof Boolean) {
                    builder.append(indent);
                    builder.append("  - ");
                    builder.append(entry);
                    builder.append("\n");
                } else if (entry instanceof Map) {
                    this.append_dict(builder, indent + "  ", null, (Map)entry, true);
                } else {
                    throw new RuntimeException("Invalid value '" + String.valueOf(entry) + "' of type " + String.valueOf(entry.getClass()) + " in mapping of ConfigDictSerializable");
                }
            });
        }
    }

    private void append_dict(StringBuilder builder, String indent, String dict_key, Map<String, Object> dict, boolean is_list_entry) {
        builder.append(indent);
        if (is_list_entry) {
            builder.append("-");
        } else {
            builder.append(dict_key);
            builder.append(":");
        }
        if (dict.isEmpty()) {
            builder.append(" {}\n");
        } else {
            builder.append("\n");
            dict.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                if (entry.getValue() instanceof String) {
                    builder.append(indent + "  ");
                    builder.append((String)entry.getKey());
                    builder.append(": ");
                    builder.append("\"" + this.escape_yaml(entry.getValue().toString()) + "\"");
                    builder.append("\n");
                } else if (entry.getValue() instanceof Integer || entry.getValue() instanceof Long || entry.getValue() instanceof Float || entry.getValue() instanceof Double || entry.getValue() instanceof Boolean) {
                    builder.append(indent + "  ");
                    builder.append((String)entry.getKey());
                    builder.append(": ");
                    builder.append(entry.getValue().toString());
                    builder.append("\n");
                } else if (entry.getValue() instanceof Map) {
                    this.append_dict(builder, indent + "  ", (String)entry.getKey(), (Map)entry.getValue(), false);
                } else if (entry.getValue() instanceof List) {
                    this.append_list(builder, indent + "  ", (String)entry.getKey(), (List)entry.getValue());
                } else {
                    throw new RuntimeException("Invalid value '" + String.valueOf(entry.getValue()) + "' of type " + String.valueOf(entry.getValue().getClass()) + " in mapping of ConfigDictSerializable");
                }
            });
        }
    }

    private void append_dict(StringBuilder builder, String indent, boolean default_definition, ConfigDictSerializable ser) {
        if (default_definition) {
            this.append_dict(builder, indent + "# ", "Default", ser.to_dict(), false);
        } else {
            this.append_dict(builder, indent, this.basename(), ser.to_dict(), false);
        }
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_dict(builder, indent, true, this.def());
        ConfigDictSerializable def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_dict(builder, indent, false, def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isConfigurationSection(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected configuration section");
        }
    }

    public ArrayList<Object> load_list_from_yaml(List<?> raw_list) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object e : raw_list) {
            if (e instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)e;
                list.add(this.load_dict_from_yaml(section));
                continue;
            }
            list.add(e);
        }
        return list;
    }

    public HashMap<String, Object> load_dict_from_yaml(ConfigurationSection section) {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        for (String subkey : section.getKeys(false)) {
            if (section.isConfigurationSection(subkey)) {
                dict.put(subkey, this.load_dict_from_yaml(section.getConfigurationSection(subkey)));
                continue;
            }
            if (section.isList(subkey)) {
                dict.put(subkey, this.load_list_from_yaml(section.getList(subkey)));
                continue;
            }
            if (section.isString(subkey)) {
                dict.put(subkey, section.getString(subkey));
                continue;
            }
            if (section.isInt(subkey)) {
                dict.put(subkey, section.getInt(subkey));
                continue;
            }
            if (section.isDouble(subkey)) {
                dict.put(subkey, section.getDouble(subkey));
                continue;
            }
            if (section.isBoolean(subkey)) {
                dict.put(subkey, section.getBoolean(subkey));
                continue;
            }
            if (section.isLong(subkey)) {
                dict.put(subkey, section.getLong(subkey));
                continue;
            }
            throw new IllegalStateException("Cannot load dict entry '" + this.yaml_path() + "." + subkey + "': unknown type");
        }
        return dict;
    }

    public ConfigDictSerializable load_from_yaml(YamlConfiguration yaml) {
        try {
            ConfigDictSerializable dict = (ConfigDictSerializable)this.annotation.cls().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            dict.from_dict(this.load_dict_from_yaml(yaml.getConfigurationSection(this.yaml_path())));
            return dict;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Could not instanciate storage class for ConfigDict: " + String.valueOf(this.annotation.cls()), e);
        }
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }

    private class EmptyDict
    implements ConfigDictSerializable {
        private EmptyDict(ConfigDictField configDictField) {
        }

        @Override
        public Map<String, Object> to_dict() {
            return new HashMap<String, Object>();
        }

        @Override
        public void from_dict(Map<String, Object> dict) {
        }
    }
}

