/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigDoubleList;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.external.apache.commons.lang3.ArrayUtils;

public class ConfigDoubleListField
extends ConfigField<List<Double>> {
    public ConfigDoubleList annotation;

    public ConfigDoubleListField(Object owner, Field field, Function<String, String> map_name, ConfigDoubleList annotation) {
        super(owner, field, map_name, "double list", annotation.desc());
        this.annotation = annotation;
    }

    private void append_double_list_definition(StringBuilder builder, String indent, String prefix, List<Double> def) {
        this.append_list_definition(builder, indent, prefix, def, (b, d) -> b.append(d));
    }

    @Override
    public List<Double> def() {
        List override = (List)this.overridden_def();
        if (override != null) {
            return override;
        }
        return Arrays.asList(ArrayUtils.toObject(this.annotation.def()));
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_value_range(builder, indent, this.annotation.min(), this.annotation.max(), Double.NaN, Double.NaN);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_double_list_definition(builder, indent, "# ", (List<Double>)this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        List<Double> def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_double_list_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isList(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected list");
        }
        for (Object obj : yaml.getList(this.yaml_path())) {
            if (!(obj instanceof Number)) {
                throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected double");
            }
            double val = yaml.getDouble(this.yaml_path());
            if (!Double.isNaN(this.annotation.min()) && val < this.annotation.min()) {
                throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be >= " + this.annotation.min());
            }
            if (Double.isNaN(this.annotation.max()) || !(val > this.annotation.max())) continue;
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be <= " + this.annotation.max());
        }
    }

    public List<Double> load_from_yaml(YamlConfiguration yaml) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object obj : yaml.getList(this.yaml_path())) {
            list.add(((Number)obj).doubleValue());
        }
        return list;
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

