/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigExtendedMaterial;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.core.material.ExtendedMaterial;
import org.oddlama.vane.util.StorageUtil;

public class ConfigExtendedMaterialField
extends ConfigField<ExtendedMaterial> {
    public ConfigExtendedMaterial annotation;

    public ConfigExtendedMaterialField(Object owner, Field field, Function<String, String> map_name, ConfigExtendedMaterial annotation) {
        super(owner, field, map_name, "extended material", annotation.desc());
        this.annotation = annotation;
    }

    @Override
    public ExtendedMaterial def() {
        ExtendedMaterial override = (ExtendedMaterial)this.overridden_def();
        if (override != null) {
            return override;
        }
        String[] split = this.annotation.def().split(":");
        if (split.length != 2) {
            throw new RuntimeException("Invalid default extended material entry for '" + this.yaml_path() + "': '" + this.annotation.def() + "' is not a valid namespaced key");
        }
        return ExtendedMaterial.from(StorageUtil.namespaced_key(split[0], split[1]));
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_default_value(builder, indent, "\"" + this.escape_yaml(this.def().key().getNamespace()) + ":" + this.escape_yaml(this.def().key().getKey()) + "\"");
        ExtendedMaterial def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_field_definition(builder, indent, "\"" + this.escape_yaml(def.key().getNamespace()) + ":" + this.escape_yaml(def.key().getKey()) + "\"");
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isString(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected string");
        }
        String str = yaml.getString(this.yaml_path());
        String[] split = str.split(":");
        if (split.length != 2) {
            throw new YamlLoadException("Invalid extended material entry in list '" + this.yaml_path() + "': '" + str + "' is not a valid namespaced key");
        }
        ExtendedMaterial mat = ExtendedMaterial.from(StorageUtil.namespaced_key(split[0], split[1]));
        if (mat == null) {
            throw new YamlLoadException("Invalid extended material entry in list '" + this.yaml_path() + "': '" + str + "' does not exist");
        }
    }

    public ExtendedMaterial load_from_yaml(YamlConfiguration yaml) {
        String[] split = yaml.getString(this.yaml_path()).split(":");
        return ExtendedMaterial.from(StorageUtil.namespaced_key(split[0], split[1]));
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

