/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.functional.Consumer2;
import org.oddlama.vane.external.apache.commons.text.WordUtils;
import org.oddlama.vane.external.bstats.bukkit.Metrics;
import org.oddlama.vane.external.bstats.charts.SimplePie;

public abstract class ConfigField<T>
implements Comparable<ConfigField<?>> {
    protected Object owner;
    protected Field field;
    protected String path;
    protected String type_name;
    protected int sort_priority = 0;
    private String[] yaml_path_components;
    private String yaml_group_path;
    private String basename;
    private Supplier<String> description;

    public ConfigField(Object owner, Field field, Function<String, String> map_name, String type_name, String description) {
        this.owner = owner;
        this.field = field;
        this.path = map_name.apply(field.getName().substring("config_".length()));
        this.yaml_path_components = this.path.split("\\.");
        int last_dot = this.path.lastIndexOf(".");
        this.yaml_group_path = last_dot == -1 ? "" : this.path.substring(0, last_dot);
        this.basename = this.yaml_path_components[this.yaml_path_components.length - 1];
        this.type_name = type_name;
        switch (this.path) {
            case "lang": {
                this.sort_priority = -10;
                break;
            }
            case "enabled": {
                this.sort_priority = -9;
                break;
            }
            case "metrics_enabled": {
                this.sort_priority = -8;
            }
        }
        field.setAccessible(true);
        this.description = () -> {
            try {
                return (String)owner.getClass().getMethod(field.getName() + "_desc", new Class[0]).invoke(owner, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                return description;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not call " + owner.getClass().getName() + "." + field.getName() + "_desc() to override description value", e);
            }
        };
    }

    protected T overridden_def() {
        try {
            return (T)this.owner.getClass().getMethod(this.field.getName() + "_def", new Class[0]).invoke(this.owner, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not call " + this.owner.getClass().getName() + "." + this.field.getName() + "_def() to override default value", e);
        }
    }

    protected Boolean overridden_metrics() {
        try {
            return (Boolean)this.owner.getClass().getMethod(this.field.getName() + "_metrics", new Class[0]).invoke(this.owner, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not call " + this.owner.getClass().getName() + "." + this.field.getName() + "_metrics() to override metrics status", e);
        }
    }

    protected String escape_yaml(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public String get_yaml_group_path() {
        return this.path;
    }

    public String yaml_path() {
        return this.path;
    }

    public String yaml_group_path() {
        return this.yaml_group_path;
    }

    public String basename() {
        return this.basename;
    }

    private String modify_yaml_path_for_sorting(String path) {
        if (path.endsWith(".enabled")) {
            return path.substring(0, path.lastIndexOf(".enabled"));
        }
        return path;
    }

    @Override
    public int compareTo(ConfigField<?> other) {
        if (this.sort_priority != other.sort_priority) {
            return this.sort_priority - other.sort_priority;
        }
        for (int i = 0; i < Math.min(this.yaml_path_components.length, other.yaml_path_components.length) - 1; ++i) {
            int c = this.yaml_path_components[i].compareTo(other.yaml_path_components[i]);
            if (c == 0) continue;
            return c;
        }
        return this.modify_yaml_path_for_sorting(this.yaml_path()).compareTo(this.modify_yaml_path_for_sorting(other.yaml_path()));
    }

    protected void append_description(StringBuilder builder, String indent) {
        String description_wrapped = indent + "# " + WordUtils.wrap(this.description.get(), Math.max(60, 80 - indent.length()), "\n" + indent + "# ", false);
        builder.append(description_wrapped);
        builder.append("\n");
    }

    protected <U> void append_list_definition(StringBuilder builder, String indent, String prefix, Collection<U> list, Consumer2<StringBuilder, U> append) {
        list.stream().forEach(i -> {
            builder.append(indent);
            builder.append(prefix);
            builder.append("  - ");
            append.apply(builder, i);
            builder.append("\n");
        });
    }

    protected <U> void append_value_range(StringBuilder builder, String indent, U min, U max, U invalid_min, U invalid_max) {
        builder.append(indent);
        builder.append("# Valid values: ");
        if (!min.equals(invalid_min)) {
            if (!max.equals(invalid_max)) {
                builder.append("[");
                builder.append(min);
                builder.append(",");
                builder.append(max);
                builder.append("]");
            } else {
                builder.append("[");
                builder.append(min);
                builder.append(",)");
            }
        } else if (!max.equals(invalid_max)) {
            builder.append("(,");
            builder.append(max);
            builder.append("]");
        } else {
            builder.append("Any " + this.type_name);
        }
        builder.append("\n");
    }

    protected void append_default_value(StringBuilder builder, String indent, Object def) {
        builder.append(indent);
        builder.append("# Default: ");
        builder.append(def);
        builder.append("\n");
    }

    protected void append_field_definition(StringBuilder builder, String indent, Object def) {
        builder.append(indent);
        builder.append(this.basename);
        builder.append(": ");
        builder.append(def);
        builder.append("\n");
    }

    protected void check_yaml_path(YamlConfiguration yaml) throws YamlLoadException {
        if (!yaml.contains(this.path, true)) {
            throw new YamlLoadException("yaml is missing entry with path '" + this.path + "'");
        }
    }

    public abstract T def();

    public boolean metrics() {
        return false;
    }

    public abstract void generate_yaml(StringBuilder var1, String var2, YamlConfiguration var3);

    public abstract void check_loadable(YamlConfiguration var1) throws YamlLoadException;

    public abstract void load(YamlConfiguration var1);

    public T get() {
        try {
            return (T)this.field.get(this.owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }

    public void register_metrics(Metrics metrics) {
        if (!this.metrics()) {
            return;
        }
        metrics.addCustomChart(new SimplePie(this.yaml_path(), () -> this.get().toString()));
    }

    public String[] components() {
        return this.yaml_path_components;
    }

    public int group_count() {
        return this.yaml_path_components.length - 1;
    }

    public static boolean same_group(ConfigField<?> a, ConfigField<?> b) {
        if (a.yaml_path_components.length != b.yaml_path_components.length) {
            return false;
        }
        for (int i = 0; i < a.yaml_path_components.length - 1; ++i) {
            if (a.yaml_path_components[i].equals(b.yaml_path_components[i])) continue;
            return false;
        }
        return true;
    }

    public static int common_group_count(ConfigField<?> a, ConfigField<?> b) {
        int i;
        for (i = 0; i < Math.min(a.yaml_path_components.length, b.yaml_path_components.length) - 1; ++i) {
            if (a.yaml_path_components[i].equals(b.yaml_path_components[i])) continue;
            return i;
        }
        return i;
    }
}

