/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;

public class ConfigIntField
extends ConfigField<Integer> {
    public ConfigInt annotation;

    public ConfigIntField(Object owner, Field field, Function<String, String> map_name, ConfigInt annotation) {
        super(owner, field, map_name, "int", annotation.desc());
        this.annotation = annotation;
    }

    @Override
    public Integer def() {
        Integer override = (Integer)this.overridden_def();
        if (override != null) {
            return override;
        }
        return this.annotation.def();
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_value_range(builder, indent, this.annotation.min(), this.annotation.max(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.append_default_value(builder, indent, this.def());
        int def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def().intValue();
        this.append_field_definition(builder, indent, def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!(yaml.get(this.yaml_path()) instanceof Number)) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected int");
        }
        int val = yaml.getInt(this.yaml_path());
        if (this.annotation.min() != Integer.MIN_VALUE && val < this.annotation.min()) {
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be >= " + this.annotation.min());
        }
        if (this.annotation.max() != Integer.MAX_VALUE && val > this.annotation.max()) {
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be <= " + this.annotation.max());
        }
    }

    public int load_from_yaml(YamlConfiguration yaml) {
        return yaml.getInt(this.yaml_path());
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.setInt(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

