/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigIntList;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.external.apache.commons.lang3.ArrayUtils;

public class ConfigIntListField
extends ConfigField<List<Integer>> {
    public ConfigIntList annotation;

    public ConfigIntListField(Object owner, Field field, Function<String, String> map_name, ConfigIntList annotation) {
        super(owner, field, map_name, "int list", annotation.desc());
        this.annotation = annotation;
    }

    private void append_int_list_definition(StringBuilder builder, String indent, String prefix, List<Integer> def) {
        this.append_list_definition(builder, indent, prefix, def, (b, i) -> b.append(i));
    }

    @Override
    public List<Integer> def() {
        List override = (List)this.overridden_def();
        if (override != null) {
            return override;
        }
        return Arrays.asList(ArrayUtils.toObject(this.annotation.def()));
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_value_range(builder, indent, this.annotation.min(), this.annotation.max(), Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_int_list_definition(builder, indent, "# ", (List<Integer>)this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        List<Integer> def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_int_list_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isList(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected list");
        }
        for (Object obj : yaml.getList(this.yaml_path())) {
            if (!(obj instanceof Number)) {
                throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected int");
            }
            int val = yaml.getInt(this.yaml_path());
            if (this.annotation.min() != Integer.MIN_VALUE && val < this.annotation.min()) {
                throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be >= " + this.annotation.min());
            }
            if (this.annotation.max() == Integer.MAX_VALUE || val <= this.annotation.max()) continue;
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be <= " + this.annotation.max());
        }
    }

    public List<Integer> load_from_yaml(YamlConfiguration yaml) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object obj : yaml.getList(this.yaml_path())) {
            list.add(((Number)obj).intValue());
        }
        return list;
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

