/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.annotation.config.ConfigItemStack;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.StorageUtil;

public class ConfigItemStackField
extends ConfigField<ItemStack> {
    public ConfigItemStack annotation;

    public ConfigItemStackField(Object owner, Field field, Function<String, String> map_name, ConfigItemStack annotation) {
        super(owner, field, map_name, "item stack", annotation.desc());
        this.annotation = annotation;
    }

    private void append_item_stack_definition(StringBuilder builder, String indent, String prefix, ItemStack def) {
        builder.append(indent);
        builder.append(prefix);
        builder.append("  material: ");
        String material = "\"" + this.escape_yaml(def.getType().getKey().getNamespace()) + ":" + this.escape_yaml(def.getType().getKey().getKey()) + "\"";
        builder.append(material);
        builder.append("\n");
        if (def.getAmount() != 1) {
            builder.append(indent);
            builder.append(prefix);
            builder.append("  amount: ");
            builder.append(def.getAmount());
            builder.append("\n");
        }
    }

    @Override
    public ItemStack def() {
        ItemStack override = (ItemStack)this.overridden_def();
        if (override != null) {
            return override;
        }
        return new ItemStack(this.annotation.def().type(), this.annotation.def().amount());
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_item_stack_definition(builder, indent, "# ", this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        ItemStack def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_item_stack_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isConfigurationSection(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected group");
        }
        for (String var_key : yaml.getConfigurationSection(this.yaml_path()).getKeys(false)) {
            String var_path = this.yaml_path() + "." + var_key;
            switch (var_key) {
                case "material": {
                    if (!yaml.isString(var_path)) {
                        throw new YamlLoadException("Invalid type for yaml path '" + var_path + "', expected list");
                    }
                    String str = yaml.getString(var_path);
                    String[] split = str.split(":");
                    if (split.length == 2) break;
                    throw new YamlLoadException("Invalid material for yaml path '" + this.yaml_path() + "': '" + str + "' is not a valid namespaced key");
                }
                case "amount": {
                    if (!(yaml.get(var_path) instanceof Number)) {
                        throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected int");
                    }
                    int val = yaml.getInt(this.yaml_path());
                    if (val >= 0) break;
                    throw new YamlLoadException("Invalid value for yaml path '" + this.yaml_path() + "' Must be >= 0");
                }
            }
        }
    }

    public ItemStack load_from_yaml(YamlConfiguration yaml) {
        String material_str = "";
        int amount = 1;
        for (String var_key : yaml.getConfigurationSection(this.yaml_path()).getKeys(false)) {
            String var_path = this.yaml_path() + "." + var_key;
            switch (var_key) {
                case "material": {
                    amount = 0;
                    material_str = yaml.getString(var_path);
                    break;
                }
                case "amount": {
                    amount = yaml.getInt(var_path);
                }
            }
        }
        String[] split = material_str.split(":");
        Material material = MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1]));
        return new ItemStack(material, amount);
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

