/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;

public class ConfigLongField
extends ConfigField<Long> {
    public ConfigLong annotation;

    public ConfigLongField(Object owner, Field field, Function<String, String> map_name, ConfigLong annotation) {
        super(owner, field, map_name, "long", annotation.desc());
        this.annotation = annotation;
    }

    @Override
    public Long def() {
        Long override = (Long)this.overridden_def();
        if (override != null) {
            return override;
        }
        return this.annotation.def();
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_value_range(builder, indent, this.annotation.min(), this.annotation.max(), Long.MIN_VALUE, Long.MAX_VALUE);
        this.append_default_value(builder, indent, this.def());
        long def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def().longValue();
        this.append_field_definition(builder, indent, def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!(yaml.get(this.yaml_path()) instanceof Number)) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected long");
        }
        long val = yaml.getLong(this.yaml_path());
        if (this.annotation.min() != Long.MIN_VALUE && val < this.annotation.min()) {
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be >= " + this.annotation.min());
        }
        if (this.annotation.max() != Long.MAX_VALUE && val > this.annotation.max()) {
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be <= " + this.annotation.max());
        }
    }

    public long load_from_yaml(YamlConfiguration yaml) {
        return yaml.getLong(this.yaml_path());
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.setLong(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

