/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigDict;
import org.oddlama.vane.annotation.config.ConfigDouble;
import org.oddlama.vane.annotation.config.ConfigDoubleList;
import org.oddlama.vane.annotation.config.ConfigExtendedMaterial;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.config.ConfigIntList;
import org.oddlama.vane.annotation.config.ConfigItemStack;
import org.oddlama.vane.annotation.config.ConfigLong;
import org.oddlama.vane.annotation.config.ConfigMaterial;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapMap;
import org.oddlama.vane.annotation.config.ConfigMaterialSet;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.annotation.config.ConfigStringList;
import org.oddlama.vane.annotation.config.ConfigStringListMap;
import org.oddlama.vane.annotation.config.ConfigVersion;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigBooleanField;
import org.oddlama.vane.core.config.ConfigDictField;
import org.oddlama.vane.core.config.ConfigDoubleField;
import org.oddlama.vane.core.config.ConfigDoubleListField;
import org.oddlama.vane.core.config.ConfigExtendedMaterialField;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.core.config.ConfigIntField;
import org.oddlama.vane.core.config.ConfigIntListField;
import org.oddlama.vane.core.config.ConfigItemStackField;
import org.oddlama.vane.core.config.ConfigLongField;
import org.oddlama.vane.core.config.ConfigMaterialField;
import org.oddlama.vane.core.config.ConfigMaterialMapMapMapField;
import org.oddlama.vane.core.config.ConfigMaterialSetField;
import org.oddlama.vane.core.config.ConfigStringField;
import org.oddlama.vane.core.config.ConfigStringListField;
import org.oddlama.vane.core.config.ConfigStringListMapField;
import org.oddlama.vane.core.config.ConfigVersionField;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.external.apache.commons.text.WordUtils;
import org.oddlama.vane.external.bstats.bukkit.Metrics;
import org.oddlama.vane.external.reflections.ReflectionUtils;

public class ConfigManager {
    private List<ConfigField<?>> config_fields = new ArrayList();
    private Map<String, String> section_descriptions = new HashMap<String, String>();
    ConfigVersionField field_version;
    Module<?> module;

    public ConfigManager(Module<?> module) {
        this.module = module;
        this.compile(module, s -> s);
    }

    public long expected_version() {
        return this.module.annotation.config_version();
    }

    private boolean has_config_annotation(Field field) {
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getName().startsWith("org.oddlama.vane.annotation.config.Config")) continue;
            return true;
        }
        return false;
    }

    private void assert_field_prefix(Field field) {
        if (!field.getName().startsWith("config_")) {
            throw new RuntimeException("Configuration fields must be prefixed config_. This is a bug.");
        }
    }

    private ConfigField<?> compile_field(Object owner, Field field, Function<String, String> map_name) {
        this.assert_field_prefix(field);
        Annotation annotation = null;
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getName().startsWith("org.oddlama.vane.annotation.config.Config")) continue;
            if (annotation == null) {
                annotation = a;
                continue;
            }
            throw new RuntimeException("Configuration fields must have exactly one @Config annotation.");
        }
        assert (annotation != null);
        Class<? extends Annotation> atype = annotation.annotationType();
        if (atype.equals(ConfigBoolean.class)) {
            return new ConfigBooleanField(owner, field, map_name, (ConfigBoolean)annotation);
        }
        if (atype.equals(ConfigDict.class)) {
            return new ConfigDictField(owner, field, map_name, (ConfigDict)annotation);
        }
        if (atype.equals(ConfigDouble.class)) {
            return new ConfigDoubleField(owner, field, map_name, (ConfigDouble)annotation);
        }
        if (atype.equals(ConfigDoubleList.class)) {
            return new ConfigDoubleListField(owner, field, map_name, (ConfigDoubleList)annotation);
        }
        if (atype.equals(ConfigExtendedMaterial.class)) {
            return new ConfigExtendedMaterialField(owner, field, map_name, (ConfigExtendedMaterial)annotation);
        }
        if (atype.equals(ConfigInt.class)) {
            return new ConfigIntField(owner, field, map_name, (ConfigInt)annotation);
        }
        if (atype.equals(ConfigIntList.class)) {
            return new ConfigIntListField(owner, field, map_name, (ConfigIntList)annotation);
        }
        if (atype.equals(ConfigItemStack.class)) {
            return new ConfigItemStackField(owner, field, map_name, (ConfigItemStack)annotation);
        }
        if (atype.equals(ConfigLong.class)) {
            return new ConfigLongField(owner, field, map_name, (ConfigLong)annotation);
        }
        if (atype.equals(ConfigMaterial.class)) {
            return new ConfigMaterialField(owner, field, map_name, (ConfigMaterial)annotation);
        }
        if (atype.equals(ConfigMaterialMapMapMap.class)) {
            return new ConfigMaterialMapMapMapField(owner, field, map_name, (ConfigMaterialMapMapMap)annotation);
        }
        if (atype.equals(ConfigMaterialSet.class)) {
            return new ConfigMaterialSetField(owner, field, map_name, (ConfigMaterialSet)annotation);
        }
        if (atype.equals(ConfigString.class)) {
            return new ConfigStringField(owner, field, map_name, (ConfigString)annotation);
        }
        if (atype.equals(ConfigStringList.class)) {
            return new ConfigStringListField(owner, field, map_name, (ConfigStringList)annotation);
        }
        if (atype.equals(ConfigStringListMap.class)) {
            return new ConfigStringListMapField(owner, field, map_name, (ConfigStringListMap)annotation);
        }
        if (atype.equals(ConfigVersion.class)) {
            if (owner != this.module) {
                throw new RuntimeException("@ConfigVersion can only be used inside the main module. This is a bug.");
            }
            if (this.field_version != null) {
                throw new RuntimeException("There must be exactly one @ConfigVersion field! (found multiple). This is a bug.");
            }
            this.field_version = new ConfigVersionField(owner, field, map_name, (ConfigVersion)annotation);
            return this.field_version;
        }
        throw new RuntimeException("Missing ConfigField handler for @" + atype.getName() + ". This is a bug.");
    }

    private boolean verify_version(File file, long version) {
        if (version != this.expected_version()) {
            this.module.log.severe(file.getName() + ": expected version " + this.expected_version() + ", but got " + version);
            if (version == 0L) {
                this.module.log.severe("Something went wrong while generating or loading the configuration.");
                this.module.log.severe("If you are sure your configuration is correct and this isn't a file");
                this.module.log.severe("system permission issue, please report this to https://github.com/oddlama/vane/issues");
            } else if (version < this.expected_version()) {
                this.module.log.severe("This config is for an older version of " + this.module.getName() + ".");
                this.module.log.severe("Please update your configuration. A new default configuration");
                this.module.log.severe("has been generated as 'config.yml.new'. Alternatively you can");
                this.module.log.severe("delete your configuration to have a new one generated next time.");
                this.generate_file(new File(this.module.getDataFolder(), "config.yml.new"), null);
            } else {
                this.module.log.severe("This config is for a future version of " + this.module.getName() + ".");
                this.module.log.severe("Please use the correct file for this version, or delete it and");
                this.module.log.severe("it will be regenerated next time the server is started.");
            }
            return false;
        }
        return true;
    }

    public void add_section_description(String yaml_path, String description) {
        this.section_descriptions.put(yaml_path, description);
    }

    public void compile(Object owner, Function<String, String> map_name) {
        this.config_fields.addAll(ReflectionUtils.getAllFields(owner.getClass(), new Predicate[0]).stream().filter(this::has_config_annotation).map(f -> this.compile_field(owner, (Field)f, map_name)).toList());
        Collections.sort(this.config_fields);
        if (owner == this.module && this.field_version == null) {
            throw new RuntimeException("There must be exactly one @ConfigVersion field! (found none). This is a bug.");
        }
    }

    private String indent_str(int level) {
        return "  ".repeat(level);
    }

    public void generate_yaml(StringBuilder builder, YamlConfiguration existing_compatible_config) {
        builder.append("# vim: set tabstop=2 softtabstop=0 expandtab shiftwidth=2:\n");
        builder.append("# This config file will automatically be updated, as long\n");
        builder.append("# as there are no incompatible changes between versions.\n");
        builder.append("# This means that additional comments will not be preserved!\n");
        ConfigField last_field = this.field_version;
        String indent = "";
        for (ConfigField<?> f : this.config_fields) {
            builder.append("\n");
            if (!ConfigField.same_group(last_field, f)) {
                int i;
                int new_indent_level = f.group_count();
                int common_indent_level = ConfigField.common_group_count(last_field, f);
                String section_path = "";
                for (i = 0; i < common_indent_level; ++i) {
                    section_path = Context.append_yaml_path(section_path, f.components()[i], ".");
                }
                for (i = common_indent_level; i < new_indent_level; ++i) {
                    indent = this.indent_str(i);
                    String section_desc = this.section_descriptions.get(section_path = Context.append_yaml_path(section_path, f.components()[i], "."));
                    if (section_desc != null) {
                        String description_wrapped = WordUtils.wrap(section_desc, Math.max(60, 80 - indent.length()), "\n" + indent + "# ", false);
                        builder.append(indent);
                        builder.append("# ");
                        builder.append(description_wrapped);
                        builder.append("\n");
                    }
                    String section_name = f.components()[i];
                    builder.append(indent);
                    builder.append(section_name);
                    builder.append(":\n");
                }
                indent = this.indent_str(new_indent_level);
            }
            f.generate_yaml(builder, indent, existing_compatible_config);
            last_field = f;
        }
    }

    public File standard_file() {
        return new File(this.module.getDataFolder(), "config.yml");
    }

    public boolean generate_file(File file, YamlConfiguration existing_compatible_config) {
        StringBuilder builder = new StringBuilder();
        this.generate_yaml(builder, existing_compatible_config);
        String content = builder.toString();
        File tmp_file = new File(file.getAbsolutePath() + ".tmp");
        try {
            Files.writeString(tmp_file.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            this.module.log.log(Level.SEVERE, "error while writing config file '" + String.valueOf(file) + "'", e);
            return false;
        }
        try {
            Files.move(tmp_file.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            this.module.log.log(Level.SEVERE, "error while atomically replacing '" + String.valueOf(file) + "' with temporary file (very recent changes might be lost)!", e);
            return false;
        }
        return true;
    }

    public boolean reload(File file) {
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        long version = yaml.getLong("version", -1L);
        if (!this.verify_version(file, version)) {
            return false;
        }
        File tmp_file = new File(this.module.getDataFolder(), "config.yml.tmp");
        if (!this.generate_file(tmp_file, yaml)) {
            return false;
        }
        try {
            Files.move(tmp_file.toPath(), this.standard_file().toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            this.module.log.log(Level.SEVERE, "error while atomically replacing '" + String.valueOf(this.standard_file()) + "' with updated version. Please manually resolve the conflict (new file is named '" + String.valueOf(tmp_file) + "')", e);
            return false;
        }
        yaml = YamlConfiguration.loadConfiguration((File)file);
        try {
            for (ConfigField<?> f : this.config_fields) {
                f.check_loadable(yaml);
            }
            for (ConfigField<?> f : this.config_fields) {
                f.load(yaml);
            }
        }
        catch (YamlLoadException e) {
            this.module.log.log(Level.SEVERE, "error while loading '" + file.getName() + "'", e);
            return false;
        }
        return true;
    }

    public void register_metrics(Metrics metrics) {
        for (ConfigField<?> f : this.config_fields) {
            f.register_metrics(metrics);
        }
    }
}

