/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigMaterial;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.StorageUtil;

public class ConfigMaterialField
extends ConfigField<Material> {
    public ConfigMaterial annotation;

    public ConfigMaterialField(Object owner, Field field, Function<String, String> map_name, ConfigMaterial annotation) {
        super(owner, field, map_name, "material", annotation.desc());
        this.annotation = annotation;
    }

    @Override
    public Material def() {
        Material override = (Material)this.overridden_def();
        if (override != null) {
            return override;
        }
        return this.annotation.def();
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_default_value(builder, indent, "\"" + this.escape_yaml(this.def().getKey().getNamespace()) + ":" + this.escape_yaml(this.def().getKey().getKey()) + "\"");
        Material def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_field_definition(builder, indent, "\"" + this.escape_yaml(def.getKey().getNamespace()) + ":" + this.escape_yaml(def.getKey().getKey()) + "\"");
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isString(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected string");
        }
        String str = yaml.getString(this.yaml_path());
        String[] split = str.split(":");
        if (split.length != 2) {
            throw new YamlLoadException("Invalid material entry in list '" + this.yaml_path() + "': '" + str + "' is not a valid namespaced key");
        }
        Material mat = MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1]));
        if (mat == null) {
            throw new YamlLoadException("Invalid material entry in list '" + this.yaml_path() + "': '" + str + "' does not exist");
        }
    }

    public Material load_from_yaml(YamlConfiguration yaml) {
        String[] split = yaml.getString(this.yaml_path()).split(":");
        return MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1]));
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

