/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigMaterialMapEntry;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapEntry;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapMap;
import org.oddlama.vane.annotation.config.ConfigMaterialMapMapMapEntry;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.StorageUtil;

public class ConfigMaterialMapMapMapField
extends ConfigField<Map<String, Map<String, Map<String, Material>>>> {
    public ConfigMaterialMapMapMap annotation;

    public ConfigMaterialMapMapMapField(Object owner, Field field, Function<String, String> map_name, ConfigMaterialMapMapMap annotation) {
        super(owner, field, map_name, "map of string to (map of string to (map of string to material))", annotation.desc());
        this.annotation = annotation;
    }

    private void append_map_definition(StringBuilder builder, String indent, String prefix, Map<String, Map<String, Map<String, Material>>> def) {
        def.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e1 -> {
            builder.append(indent);
            builder.append(prefix);
            builder.append("  ");
            builder.append(this.escape_yaml((String)e1.getKey()));
            builder.append(":\n");
            ((Map)e1.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e2 -> {
                builder.append(indent);
                builder.append(prefix);
                builder.append("    ");
                builder.append(this.escape_yaml((String)e2.getKey()));
                builder.append(":\n");
                ((Map)e2.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e3 -> {
                    builder.append(indent);
                    builder.append(prefix);
                    builder.append("      ");
                    builder.append(this.escape_yaml((String)e3.getKey()));
                    builder.append(": \"");
                    builder.append(this.escape_yaml(((Material)e3.getValue()).getKey().getNamespace()));
                    builder.append(":");
                    builder.append(this.escape_yaml(((Material)e3.getValue()).getKey().getKey()));
                    builder.append("\"\n");
                });
            });
        });
    }

    @Override
    public Map<String, Map<String, Map<String, Material>>> def() {
        Map override = (Map)this.overridden_def();
        if (override != null) {
            return override;
        }
        return Arrays.stream(this.annotation.def()).collect(Collectors.toMap(ConfigMaterialMapMapMapEntry::key, e1 -> Arrays.stream(e1.value()).collect(Collectors.toMap(ConfigMaterialMapMapEntry::key, e2 -> Arrays.stream(e2.value()).collect(Collectors.toMap(ConfigMaterialMapEntry::key, e3 -> e3.value()))))));
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_map_definition(builder, indent, "# ", (Map<String, Map<String, Map<String, Material>>>)this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        Map<String, Map<String, Map<String, Material>>> def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_map_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isConfigurationSection(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected group");
        }
        for (String key1 : yaml.getConfigurationSection(this.yaml_path()).getKeys(false)) {
            String key1_path = this.yaml_path() + "." + key1;
            if (!yaml.isConfigurationSection(key1_path)) {
                throw new YamlLoadException("Invalid type for yaml path '" + key1_path + "', expected group");
            }
            for (String key2 : yaml.getConfigurationSection(key1_path).getKeys(false)) {
                String key2_path = key1_path + "." + key2;
                if (!yaml.isConfigurationSection(key2_path)) {
                    throw new YamlLoadException("Invalid type for yaml path '" + key2_path + "', expected group");
                }
                for (String key3 : yaml.getConfigurationSection(key2_path).getKeys(false)) {
                    String key3_path = key2_path + "." + key3;
                    if (!yaml.isString(key3_path)) {
                        throw new YamlLoadException("Invalid type for yaml path '" + key3_path + "', expected string");
                    }
                    String str = yaml.getString(key3_path);
                    String[] split = str.split(":");
                    if (split.length != 2) {
                        throw new YamlLoadException("Invalid material entry in list '" + key3_path + "': '" + str + "' is not a valid namespaced key");
                    }
                    Material mat = MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1]));
                    if (mat != null) continue;
                    throw new YamlLoadException("Invalid material entry in list '" + key3_path + "': '" + str + "' does not exist");
                }
            }
        }
    }

    public Map<String, Map<String, Map<String, Material>>> load_from_yaml(YamlConfiguration yaml) {
        HashMap<String, Map<String, Map<String, Material>>> map1 = new HashMap<String, Map<String, Map<String, Material>>>();
        for (String key1 : yaml.getConfigurationSection(this.yaml_path()).getKeys(false)) {
            String key1_path = this.yaml_path() + "." + key1;
            HashMap map2 = new HashMap();
            map1.put(key1, map2);
            for (String key2 : yaml.getConfigurationSection(key1_path).getKeys(false)) {
                String key2_path = key1_path + "." + key2;
                HashMap<String, Material> map3 = new HashMap<String, Material>();
                map2.put(key2, map3);
                for (String key3 : yaml.getConfigurationSection(key2_path).getKeys(false)) {
                    String key3_path = key2_path + "." + key3;
                    String[] split = yaml.getString(key3_path).split(":");
                    map3.put(key3, MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1])));
                }
            }
        }
        return map1;
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

