/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigMaterialSet;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.external.bstats.bukkit.Metrics;
import org.oddlama.vane.external.bstats.charts.AdvancedPie;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.StorageUtil;

public class ConfigMaterialSetField
extends ConfigField<Set<Material>> {
    public ConfigMaterialSet annotation;

    public ConfigMaterialSetField(Object owner, Field field, Function<String, String> map_name, ConfigMaterialSet annotation) {
        super(owner, field, map_name, "set of materials", annotation.desc());
        this.annotation = annotation;
    }

    private void append_material_set_definition(StringBuilder builder, String indent, String prefix, Set<Material> def) {
        this.append_list_definition(builder, indent, prefix, def, (b, m) -> {
            b.append("\"");
            b.append(this.escape_yaml(m.getKey().getNamespace()));
            b.append(":");
            b.append(this.escape_yaml(m.getKey().getKey()));
            b.append("\"");
        });
    }

    @Override
    public Set<Material> def() {
        Set override = (Set)this.overridden_def();
        if (override != null) {
            return override;
        }
        return new HashSet<Material>(Arrays.asList(this.annotation.def()));
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void register_metrics(Metrics metrics) {
        if (!this.metrics()) {
            return;
        }
        metrics.addCustomChart(new AdvancedPie(this.yaml_path(), () -> {
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            for (Material v : (Set)this.get()) {
                values.put(v.getKey().toString(), 1);
            }
            return values;
        }));
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_material_set_definition(builder, indent, "# ", (Set<Material>)this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        Set<Material> def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_material_set_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isList(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected list");
        }
        for (Object obj : yaml.getList(this.yaml_path())) {
            if (!(obj instanceof String)) {
                throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected string");
            }
            String str = (String)obj;
            String[] split = str.split(":");
            if (split.length != 2) {
                throw new YamlLoadException("Invalid material entry in list '" + this.yaml_path() + "': '" + str + "' is not a valid namespaced key");
            }
            Material mat = MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1]));
            if (mat != null) continue;
            throw new YamlLoadException("Invalid material entry in list '" + this.yaml_path() + "': '" + str + "' does not exist");
        }
    }

    public Set<Material> load_from_yaml(YamlConfiguration yaml) {
        HashSet<Material> set = new HashSet<Material>();
        for (Object obj : yaml.getList(this.yaml_path())) {
            String[] split = ((String)obj).split(":");
            set.add(MaterialUtil.material_from(StorageUtil.namespaced_key(split[0], split[1])));
        }
        return set;
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

