/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigString;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;

public class ConfigStringField
extends ConfigField<String> {
    public ConfigString annotation;

    public ConfigStringField(Object owner, Field field, Function<String, String> map_name, ConfigString annotation) {
        super(owner, field, map_name, "string", annotation.desc());
        this.annotation = annotation;
    }

    @Override
    public String def() {
        String override = (String)this.overridden_def();
        if (override != null) {
            return override;
        }
        return this.annotation.def();
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_default_value(builder, indent, "\"" + this.escape_yaml(this.def()) + "\"");
        String def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_field_definition(builder, indent, "\"" + this.escape_yaml(def) + "\"");
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isString(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected string");
        }
    }

    public String load_from_yaml(YamlConfiguration yaml) {
        return yaml.getString(this.yaml_path());
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

