/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigStringList;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;

public class ConfigStringListField
extends ConfigField<List<String>> {
    public ConfigStringList annotation;

    public ConfigStringListField(Object owner, Field field, Function<String, String> map_name, ConfigStringList annotation) {
        super(owner, field, map_name, "list of strings", annotation.desc());
        this.annotation = annotation;
    }

    private void append_string_list_definition(StringBuilder builder, String indent, String prefix, List<String> def) {
        this.append_list_definition(builder, indent, prefix, def, (b, s) -> {
            b.append("\"");
            b.append(this.escape_yaml((String)s));
            b.append("\"");
        });
    }

    @Override
    public List<String> def() {
        List override = (List)this.overridden_def();
        if (override != null) {
            return override;
        }
        return Arrays.asList(this.annotation.def());
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_string_list_definition(builder, indent, "# ", (List<String>)this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        List<String> def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_string_list_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isList(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected list");
        }
        for (Object obj : yaml.getList(this.yaml_path())) {
            if (obj instanceof String) continue;
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected string");
        }
    }

    public List<String> load_from_yaml(YamlConfiguration yaml) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : yaml.getList(this.yaml_path())) {
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

