/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigStringListMap;
import org.oddlama.vane.annotation.config.ConfigStringListMapEntry;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;

public class ConfigStringListMapField
extends ConfigField<Map<String, List<String>>> {
    public ConfigStringListMap annotation;

    public ConfigStringListMapField(Object owner, Field field, Function<String, String> map_name, ConfigStringListMap annotation) {
        super(owner, field, map_name, "map of string to string list", annotation.desc());
        this.annotation = annotation;
    }

    private void append_string_list_map_definition(StringBuilder builder, String indent, String prefix, Map<String, List<String>> def) {
        def.forEach((k, list) -> {
            builder.append(indent);
            builder.append(prefix);
            builder.append("  ");
            builder.append(this.escape_yaml((String)k));
            builder.append(":\n");
            list.forEach(s -> {
                builder.append(indent);
                builder.append(prefix);
                builder.append("    - ");
                builder.append(this.escape_yaml((String)s));
                builder.append("\n");
            });
        });
    }

    @Override
    public Map<String, List<String>> def() {
        Map override = (Map)this.overridden_def();
        if (override != null) {
            return override;
        }
        return Arrays.stream(this.annotation.def()).collect(Collectors.toMap(ConfigStringListMapEntry::key, e -> Arrays.asList(e.list())));
    }

    @Override
    public boolean metrics() {
        Boolean override = this.overridden_metrics();
        if (override != null) {
            return override;
        }
        return this.annotation.metrics();
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        builder.append(indent);
        builder.append("# Default:\n");
        this.append_string_list_map_definition(builder, indent, "# ", (Map<String, List<String>>)this.def());
        builder.append(indent);
        builder.append(this.basename());
        builder.append(":\n");
        Map<String, List<String>> def = existing_compatible_config != null && existing_compatible_config.contains(this.yaml_path()) ? this.load_from_yaml(existing_compatible_config) : this.def();
        this.append_string_list_map_definition(builder, indent, "", def);
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isConfigurationSection(this.yaml_path())) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected group");
        }
        for (String list_key : yaml.getConfigurationSection(this.yaml_path()).getKeys(false)) {
            String list_path = this.yaml_path() + "." + list_key;
            if (!yaml.isList(list_path)) {
                throw new YamlLoadException("Invalid type for yaml path '" + list_path + "', expected list");
            }
            for (Object obj : yaml.getList(list_path)) {
                if (obj instanceof String) continue;
                throw new YamlLoadException("Invalid type for yaml path '" + list_path + "', expected string");
            }
        }
    }

    public Map<String, List<String>> load_from_yaml(YamlConfiguration yaml) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String list_key : yaml.getConfigurationSection(this.yaml_path()).getKeys(false)) {
            String list_path = this.yaml_path() + "." + list_key;
            ArrayList<String> list = new ArrayList<String>();
            map.put(list_key, list);
            for (Object obj : yaml.getList(list_path)) {
                list.add((String)obj);
            }
        }
        return map;
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

