/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.config.ConfigVersion;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.config.ConfigField;
import org.oddlama.vane.core.module.Module;

public class ConfigVersionField
extends ConfigField<Long> {
    public ConfigVersion annotation;

    public ConfigVersionField(Object owner, Field field, Function<String, String> map_name, ConfigVersion annotation) {
        super(owner, field, map_name, "version id", "DO NOT CHANGE! The version of this config file. Used to determine if the config needs to be updated.");
        this.annotation = annotation;
        this.sort_priority = 100;
    }

    @Override
    public Long def() {
        return null;
    }

    @Override
    public boolean metrics() {
        return true;
    }

    @Override
    public void generate_yaml(StringBuilder builder, String indent, YamlConfiguration existing_compatible_config) {
        this.append_description(builder, indent);
        this.append_field_definition(builder, indent, ((Module)this.owner).annotation.config_version());
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!(yaml.get(this.yaml_path()) instanceof Number)) {
            throw new YamlLoadException("Invalid type for yaml path '" + this.yaml_path() + "', expected long");
        }
        long val = yaml.getLong(this.yaml_path());
        if (val < 1L) {
            throw new YamlLoadException("Configuration '" + this.yaml_path() + "' has an invalid value: Value must be >= 1");
        }
    }

    public long load_from_yaml(YamlConfiguration yaml) {
        return yaml.getLong(this.yaml_path());
    }

    @Override
    public void load(YamlConfiguration yaml) {
        try {
            this.field.setLong(this.owner, this.load_from_yaml(yaml));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }
}

