/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.loot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.loot.LootTables;
import org.oddlama.vane.core.LootTable;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.StorageUtil;

public class LootDefinition {
    public String name;
    public List<NamespacedKey> affected_tables = new ArrayList<NamespacedKey>();
    public List<Entry> entries = new ArrayList<Entry>();

    public LootDefinition(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public NamespacedKey key(NamespacedKey base_key) {
        return StorageUtil.namespaced_key(base_key.namespace(), base_key.value() + "." + this.name);
    }

    public LootDefinition in(NamespacedKey table) {
        this.affected_tables.add(table);
        return this;
    }

    public LootDefinition in(LootTables table) {
        return this.in(table.getKey());
    }

    private LootDefinition add(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    public LootDefinition add(double chance, int amount_min, int amount_max, String item_definition) {
        return this.add(new Entry(chance, amount_min, amount_max, item_definition));
    }

    public Object serialize() {
        HashMap<String, List<Object>> dict = new HashMap<String, List<Object>>();
        dict.put("tables", this.affected_tables.stream().map(NamespacedKey::toString).toList());
        dict.put("items", this.entries.stream().map(Entry::serialize).toList());
        return dict;
    }

    public static LootDefinition deserialize(String name, Object raw_dict) {
        if (!(raw_dict instanceof Map)) {
            throw new IllegalArgumentException("Invalid loot table: Argument must be a Map<String, Object>, but is " + String.valueOf(raw_dict.getClass()) + "!");
        }
        Map dict = (Map)raw_dict;
        Map table_dict = dict;
        Object v = table_dict.get("tables");
        if (!(v instanceof List)) {
            throw new IllegalArgumentException("Invalid loot table: Argument must be a Map<String, Object>, but is " + String.valueOf(raw_dict.getClass()) + "!");
        }
        List tables = (List)v;
        Object v2 = table_dict.get("items");
        if (!(v2 instanceof List)) {
            throw new IllegalArgumentException("Invalid loot table: Argument must be a Map<String, Object>, but is " + String.valueOf(raw_dict.getClass()) + "!");
        }
        List items = (List)v2;
        LootDefinition table = new LootDefinition(name);
        for (Object e : tables) {
            if (!(e instanceof String)) continue;
            String key = (String)e;
            table.in(NamespacedKey.fromString((String)key));
        }
        for (Object e : items) {
            if (!(e instanceof Map)) continue;
            Map map = (Map)e;
            table.add(Entry.deserialize(map));
        }
        return table;
    }

    public List<LootTable.LootTableEntry> entries() {
        return this.entries.stream().map(e -> new LootTable.LootTableEntry(e.chance, ItemUtil.itemstack_from_string(e.item_definition).getLeft(), e.amount_min, e.amount_max)).toList();
    }

    private record Entry(double chance, int amount_min, int amount_max, String item_definition) {
        public Object serialize() {
            HashMap<String, Object> dict = new HashMap<String, Object>();
            dict.put("chance", this.chance);
            dict.put("amount_min", this.amount_min);
            dict.put("amount_max", this.amount_max);
            dict.put("item", this.item_definition);
            return dict;
        }

        public static Entry deserialize(Map<String, Object> map) {
            Object object = map.get("chance");
            if (!(object instanceof Double)) {
                throw new IllegalArgumentException("Invalid loot table entry: chance must be a double!");
            }
            Double chance = (Double)object;
            Object object2 = map.get("amount_min");
            if (!(object2 instanceof Integer)) {
                throw new IllegalArgumentException("Invalid loot table entry: amount_min must be a int!");
            }
            Integer amount_min = (Integer)object2;
            Object object3 = map.get("amount_max");
            if (!(object3 instanceof Integer)) {
                throw new IllegalArgumentException("Invalid loot table entry: amount_max must be a int!");
            }
            Integer amount_max = (Integer)object3;
            Object object4 = map.get("item");
            if (!(object4 instanceof String)) {
                throw new IllegalArgumentException("Invalid loot table entry: item_definition must be a String!");
            }
            String item_definition = (String)object4;
            return new Entry(chance, amount_min, amount_max, item_definition);
        }
    }
}

