/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.loot;

import java.util.List;
import java.util.function.Supplier;
import org.bukkit.NamespacedKey;
import org.oddlama.vane.annotation.config.ConfigBoolean;
import org.oddlama.vane.annotation.config.ConfigDict;
import org.oddlama.vane.core.LootTable;
import org.oddlama.vane.core.config.loot.LootTableList;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.module.ModuleComponent;

public class LootTables<T extends Module<T>>
extends ModuleComponent<T> {
    private final NamespacedKey base_loot_key;
    @ConfigBoolean(def=true, desc="Whether the loot should be registered. Set to false to quickly disable all associated loot.")
    public boolean config_register_loot;
    @ConfigDict(cls=LootTableList.class, desc="")
    private LootTableList config_loot;
    private Supplier<LootTableList> def_loot;
    private String desc;

    public LootTables(Context<T> context, NamespacedKey base_loot_key, Supplier<LootTableList> def_loot) {
        this(context, base_loot_key, def_loot, "The associated loot. This is a map of loot tables (as defined by minecraft) to additional loot. This additional loot is a list of loot definitions, which specify the amount and loot percentage for a particular item.");
    }

    public LootTables(Context<T> context, NamespacedKey base_loot_key, Supplier<LootTableList> def_loot, String desc) {
        super(context);
        this.base_loot_key = base_loot_key;
        this.def_loot = def_loot;
        this.desc = desc;
    }

    public LootTableList config_loot_def() {
        return this.def_loot.get();
    }

    public String config_loot_desc() {
        return this.desc;
    }

    @Override
    public void on_config_change() {
        this.config_loot.tables().forEach(table -> table.affected_tables.forEach(table_key -> ((Module)this.get_module()).loot_table((NamespacedKey)table_key).remove(table.key(this.base_loot_key))));
        if (this.enabled() && this.config_register_loot) {
            this.config_loot.tables().forEach(table -> {
                List<LootTable.LootTableEntry> entries = table.entries();
                table.affected_tables.forEach(table_key -> ((Module)this.get_module()).loot_table((NamespacedKey)table_key).put(table.key(this.base_loot_key), entries));
            });
        }
    }

    @Override
    protected void on_enable() {
    }

    @Override
    protected void on_disable() {
    }
}

