/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.recipes;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmokingRecipe;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.util.ItemUtil;

public class CookingRecipeDefinition
extends RecipeDefinition {
    private String input = null;
    private String result = null;
    private float experience = 0.0f;
    private int cooking_time = 10;
    private String type;

    public CookingRecipeDefinition(String name, String type) {
        super(name);
        switch (this.type = type) {
            case "blasting": 
            case "furnace": 
            case "campfire": 
            case "smoking": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid cooking recipe: Unknown type '" + this.type + "'");
            }
        }
    }

    public CookingRecipeDefinition input(String input) {
        this.input = input;
        return this;
    }

    public CookingRecipeDefinition input(Tag<?> tag) {
        return this.input("#" + String.valueOf(tag.key()));
    }

    public CookingRecipeDefinition input(Material material) {
        return this.input(material.key().toString());
    }

    public CookingRecipeDefinition result(String result) {
        this.result = result;
        return this;
    }

    @Override
    public Object to_dict() {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put("cooking_time", this.cooking_time);
        dict.put("experience", Float.valueOf(this.experience));
        dict.put("input", this.input);
        dict.put("result", this.result);
        dict.put("type", this.type);
        return dict;
    }

    @Override
    public RecipeDefinition from_dict(Object dict) {
        String result;
        String input;
        if (!(dict instanceof Map)) {
            throw new IllegalArgumentException("Invalid " + this.type + " recipe dictionary: Argument must be a Map<String, Object>!");
        }
        Map dict_map = (Map)dict;
        Object v = dict_map.get("input");
        if (!(v instanceof String)) {
            throw new IllegalArgumentException("Invalid " + this.type + " recipe dictionary: input must be a string");
        }
        this.input = input = (String)v;
        Object v2 = dict_map.get("result");
        if (!(v2 instanceof String)) {
            throw new IllegalArgumentException("Invalid " + this.type + " recipe dictionary: result must be a string");
        }
        this.result = result = (String)v2;
        Object v3 = dict_map.get("experience");
        if (!(v3 instanceof Float)) {
            throw new IllegalArgumentException("Invalid " + this.type + " recipe dictionary: experience must be a float");
        }
        Float experience = (Float)v3;
        this.experience = experience.floatValue();
        Object v4 = dict_map.get("cooking_time");
        if (!(v4 instanceof Integer)) {
            throw new IllegalArgumentException("Invalid " + this.type + " recipe dictionary: cooking_time must be a int");
        }
        Integer cooking_time = (Integer)v4;
        this.cooking_time = cooking_time;
        return this;
    }

    @Override
    public Recipe to_recipe(NamespacedKey base_key) {
        ItemStack out = ItemUtil.itemstack_from_string(this.result).getLeft();
        RecipeChoice in = RecipeDefinition.recipe_choice(this.input);
        switch (this.type) {
            case "blasting": {
                return new BlastingRecipe(this.key(base_key), out, in, this.experience, this.cooking_time);
            }
            case "furnace": {
                return new FurnaceRecipe(this.key(base_key), out, in, this.experience, this.cooking_time);
            }
            case "campfire": {
                return new CampfireRecipe(this.key(base_key), out, in, this.experience, this.cooking_time);
            }
            case "smoking": {
                return new SmokingRecipe(this.key(base_key), out, in, this.experience, this.cooking_time);
            }
        }
        throw new IllegalArgumentException("Invalid cooking recipe: Unknown type '" + this.type + "'");
    }
}

