/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.recipes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.config.recipes.CookingRecipeDefinition;
import org.oddlama.vane.core.config.recipes.ShapedRecipeDefinition;
import org.oddlama.vane.core.config.recipes.ShapelessRecipeDefinition;
import org.oddlama.vane.core.config.recipes.SmithingRecipeDefinition;
import org.oddlama.vane.core.config.recipes.StonecuttingRecipeDefinition;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.MaterialUtil;
import org.oddlama.vane.util.StorageUtil;

public abstract class RecipeDefinition {
    public String name;

    public RecipeDefinition(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public NamespacedKey key(NamespacedKey base_key) {
        return StorageUtil.namespaced_key(base_key.namespace(), base_key.value() + "." + this.name);
    }

    public abstract Recipe to_recipe(NamespacedKey var1);

    public abstract Object to_dict();

    public abstract RecipeDefinition from_dict(Object var1);

    public static RecipeDefinition from_dict(String name, Object dict) {
        String str_type;
        if (!(dict instanceof Map)) {
            throw new IllegalArgumentException("Invalid recipe dictionary: Argument must be a Map<String, Object>, but is " + String.valueOf(dict.getClass()) + "!");
        }
        Object type = ((Map)dict).get("type");
        if (!(type instanceof String)) {
            throw new IllegalArgumentException("Invalid recipe dictionary: recipe type must exist and be a string!");
        }
        switch (str_type = (String)type) {
            case "shaped": {
                return new ShapedRecipeDefinition(name).from_dict(dict);
            }
            case "shapeless": {
                return new ShapelessRecipeDefinition(name).from_dict(dict);
            }
            case "blasting": 
            case "furnace": 
            case "campfire": 
            case "smoking": {
                return new CookingRecipeDefinition(name, str_type).from_dict(dict);
            }
            case "smithing": {
                return new SmithingRecipeDefinition(name).from_dict(dict);
            }
            case "stonecutting": {
                return new StonecuttingRecipeDefinition(name).from_dict(dict);
            }
        }
        throw new IllegalArgumentException("Unknown recipe type '" + str_type + "'");
    }

    @NotNull
    public static RecipeChoice recipe_choice(String definition) {
        if ((definition = definition.strip()).startsWith("#")) {
            for (Field f : Tag.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Tag.class) continue;
                try {
                    Tag tag = (Tag)f.get(null);
                    if (tag == null || !tag.key().toString().equals(definition.substring(1))) continue;
                    return new RecipeChoice.MaterialChoice(tag);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid material tag: " + definition);
                }
            }
            throw new IllegalArgumentException("Unknown material tag: " + definition);
        }
        if (definition.startsWith("(") && definition.endsWith(")")) {
            List parts = Arrays.stream(definition.substring(1, definition.length() - 1).split(",")).map(key -> {
                Material mat = MaterialUtil.material_from(NamespacedKey.fromString((String)key.strip()));
                if (mat == null) {
                    throw new IllegalArgumentException("Unknown material (only normal materials are allowed in tags): " + key);
                }
                return mat;
            }).collect(Collectors.toList());
            return new RecipeChoice.MaterialChoice(parts);
        }
        int mult = definition.indexOf(42);
        int amount = 1;
        if (mult != -1) {
            String amount_str = definition.substring(0, mult).strip();
            try {
                amount = Integer.parseInt(amount_str);
                if (amount <= 0) {
                    amount = 1;
                }
                definition = definition.substring(mult + 1).strip();
            }
            catch (NumberFormatException f) {
                // empty catch block
            }
        }
        Pair<ItemStack, Boolean> item_stack_and_is_simple_mat = ItemUtil.itemstack_from_string(definition);
        ItemStack item_stack = item_stack_and_is_simple_mat.getLeft();
        Boolean is_simple_mat = item_stack_and_is_simple_mat.getRight();
        if (is_simple_mat.booleanValue() && amount == 1) {
            return new RecipeChoice.MaterialChoice(item_stack.getType());
        }
        item_stack.setAmount(amount);
        return new RecipeChoice.ExactChoice(item_stack);
    }
}

