/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.oddlama.vane.core.config.ConfigDictSerializable;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;

public class RecipeList
implements ConfigDictSerializable {
    private List<RecipeDefinition> recipes = new ArrayList<RecipeDefinition>();

    public RecipeList() {
    }

    public RecipeList(List<RecipeDefinition> recipes) {
        this.recipes = recipes;
    }

    public List<RecipeDefinition> recipes() {
        return this.recipes;
    }

    @Override
    public Map<String, Object> to_dict() {
        return this.recipes.stream().collect(Collectors.toMap(RecipeDefinition::name, RecipeDefinition::to_dict));
    }

    @Override
    public void from_dict(Map<String, Object> dict) {
        this.recipes.clear();
        for (Map.Entry<String, Object> e : dict.entrySet()) {
            this.recipes.add(RecipeDefinition.from_dict(e.getKey(), e.getValue()));
        }
    }

    public static RecipeList of(RecipeDefinition ... defs) {
        RecipeList rl = new RecipeList();
        rl.recipes = Arrays.asList(defs);
        return rl;
    }
}

