/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.recipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.util.ItemUtil;

public class ShapelessRecipeDefinition
extends RecipeDefinition {
    private List<String> ingredients = new ArrayList<String>();
    private String result = null;

    public ShapelessRecipeDefinition(String name) {
        super(name);
    }

    public ShapelessRecipeDefinition add_ingredient(String ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public ShapelessRecipeDefinition add_ingredient(Tag<?> tag) {
        return this.add_ingredient("#" + String.valueOf(tag.key()));
    }

    public ShapelessRecipeDefinition add_ingredient(Material material) {
        return this.add_ingredient(material.key().toString());
    }

    public ShapelessRecipeDefinition result(String result) {
        this.result = result;
        return this;
    }

    @Override
    public Object to_dict() {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put("type", "shapeless");
        dict.put("ingredients", this.ingredients);
        dict.put("result", this.result);
        return dict;
    }

    @Override
    public RecipeDefinition from_dict(Object dict) {
        String result;
        if (!(dict instanceof Map)) {
            throw new IllegalArgumentException("Invalid shapeless recipe dictionary: Argument must be a Map<String, Object>!");
        }
        Map dict_map = (Map)dict;
        Object v = dict_map.get("ingredients");
        if (!(v instanceof List)) {
            throw new IllegalArgumentException("Invalid shapeless recipe dictionary: ingredients must be a list of strings");
        }
        List ingredients = (List)v;
        this.ingredients = ingredients.stream().map(i -> (String)i).toList();
        Object v2 = dict_map.get("result");
        if (!(v2 instanceof String)) {
            throw new IllegalArgumentException("Invalid shapeless recipe dictionary: result must be a string");
        }
        this.result = result = (String)v2;
        return this;
    }

    @Override
    public Recipe to_recipe(NamespacedKey base_key) {
        ShapelessRecipe recipe = new ShapelessRecipe(this.key(base_key), ItemUtil.itemstack_from_string(this.result).getLeft());
        this.ingredients.forEach(i -> recipe.addIngredient(RecipeDefinition.recipe_choice(i)));
        return recipe;
    }
}

