/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.config.recipes;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.util.ItemUtil;

public class SmithingRecipeDefinition
extends RecipeDefinition {
    private String base = null;
    private String addition = null;
    private boolean copy_nbt = false;
    private String result = null;

    public SmithingRecipeDefinition(String name) {
        super(name);
    }

    public SmithingRecipeDefinition base(String base) {
        this.base = base;
        return this;
    }

    public SmithingRecipeDefinition base(Tag<?> tag) {
        return this.base("#" + String.valueOf(tag.key()));
    }

    public SmithingRecipeDefinition base(Material material) {
        return this.base(material.key().toString());
    }

    public SmithingRecipeDefinition addition(String addition) {
        this.addition = addition;
        return this;
    }

    public SmithingRecipeDefinition copy_nbt(boolean copy_nbt) {
        this.copy_nbt = copy_nbt;
        return this;
    }

    public SmithingRecipeDefinition addition(Tag<?> tag) {
        return this.addition("#" + String.valueOf(tag.key()));
    }

    public SmithingRecipeDefinition addition(Material material) {
        return this.addition(material.key().toString());
    }

    public SmithingRecipeDefinition result(String result) {
        this.result = result;
        return this;
    }

    @Override
    public Object to_dict() {
        HashMap<String, Object> dict = new HashMap<String, Object>();
        dict.put("base", this.base);
        dict.put("addition", this.addition);
        dict.put("copy_nbt", this.copy_nbt);
        dict.put("result", this.result);
        dict.put("type", "smithing");
        return dict;
    }

    @Override
    public RecipeDefinition from_dict(Object dict) {
        String result;
        String addition;
        String base;
        if (!(dict instanceof Map)) {
            throw new IllegalArgumentException("Invalid smithing recipe dictionary: Argument must be a Map<String, Object>!");
        }
        Map dict_map = (Map)dict;
        Object v = dict_map.get("base");
        if (!(v instanceof String)) {
            throw new IllegalArgumentException("Invalid smithing recipe dictionary: base must be a string");
        }
        this.base = base = (String)v;
        Object v2 = dict_map.get("addition");
        if (!(v2 instanceof String)) {
            throw new IllegalArgumentException("Invalid smithing recipe dictionary: addition must be a string");
        }
        this.addition = addition = (String)v2;
        Object v3 = dict_map.get("copy_nbt");
        if (!(v3 instanceof Boolean)) {
            throw new IllegalArgumentException("Invalid smithing recipe dictionary: copy_nbt must be a bool");
        }
        Boolean copy_nbt = (Boolean)v3;
        this.copy_nbt = copy_nbt;
        Object v4 = dict_map.get("result");
        if (!(v4 instanceof String)) {
            throw new IllegalArgumentException("Invalid smithing recipe dictionary: result must be a string");
        }
        this.result = result = (String)v4;
        return this;
    }

    @Override
    public Recipe to_recipe(NamespacedKey base_key) {
        return new SmithingTransformRecipe(this.key(base_key), ItemUtil.itemstack_from_string(this.result).getLeft(), (RecipeChoice)new RecipeChoice.MaterialChoice(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE), RecipeDefinition.recipe_choice(this.base), RecipeDefinition.recipe_choice(this.addition), this.copy_nbt);
    }
}

