/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.data;

import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public class CooldownData {
    private final NamespacedKey key;
    private final long cooldown_time;

    public CooldownData(NamespacedKey key, long cooldown_time) {
        this.key = key;
        this.cooldown_time = cooldown_time;
    }

    public boolean check_or_update_cooldown(PersistentDataHolder holder) {
        PersistentDataContainer persistent_data = holder.getPersistentDataContainer();
        Long last_time = (Long)persistent_data.getOrDefault(this.key, PersistentDataType.LONG, (Object)0L);
        long now = System.currentTimeMillis();
        if (now - last_time < this.cooldown_time) {
            return false;
        }
        persistent_data.set(this.key, PersistentDataType.LONG, (Object)now);
        return true;
    }

    public boolean peek_cooldown(PersistentDataHolder holder) {
        PersistentDataContainer persistent_data = holder.getPersistentDataContainer();
        Long last_time = (Long)persistent_data.getOrDefault(this.key, PersistentDataType.LONG, (Object)0L);
        long now = System.currentTimeMillis();
        return now - last_time >= this.cooldown_time;
    }

    public void clear(PersistentDataHolder holder) {
        PersistentDataContainer persistent_data = holder.getPersistentDataContainer();
        persistent_data.remove(this.key);
    }
}

