/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.enchantments;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.annotation.enchantment.Rarity;
import org.oddlama.vane.annotation.enchantment.VaneEnchantment;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.config.loot.LootDefinition;
import org.oddlama.vane.core.config.loot.LootTableList;
import org.oddlama.vane.core.config.loot.LootTables;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.Recipes;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.util.StorageUtil;

public class CustomEnchantment<T extends Module<T>>
extends Listener<T> {
    private static final Map<Class<?>, CustomEnchantment<?>> instances = new HashMap();
    private VaneEnchantment annotation = this.getClass().getAnnotation(VaneEnchantment.class);
    private String name = this.annotation.name();
    private NamespacedKey key;
    public Recipes<T> recipes;
    public LootTables<T> loot_tables;
    @LangMessage
    public TranslatedMessage lang_name;

    public CustomEnchantment(Context<T> context) {
        this(context, true);
    }

    public CustomEnchantment(Context<T> context, boolean default_enabled) {
        super(null);
        context = context.group("enchantment_" + this.name, "Enable enchantment " + this.name, default_enabled);
        this.set_context(context);
        this.key = StorageUtil.namespaced_key(((Module)this.get_module()).namespace(), this.name);
        if (instances.get(this.getClass()) != null) {
            throw new RuntimeException("Cannot create two instances of a custom enchantment!");
        }
        instances.put(this.getClass(), this);
        this.recipes = new Recipes(this.get_context(), this.key, this::default_recipes);
        this.loot_tables = new LootTables(this.get_context(), this.key, this::default_loot_tables);
    }

    public final Enchantment bukkit() {
        return (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(this.key);
    }

    public final NamespacedKey key() {
        return this.key;
    }

    final String get_name() {
        return this.name;
    }

    public Component apply_display_format(Component component) {
        switch (this.annotation.rarity()) {
            default: {
                return component.color((TextColor)NamedTextColor.DARK_AQUA);
            }
            case RARE: {
                return component.color((TextColor)NamedTextColor.GOLD);
            }
            case VERY_RARE: 
        }
        return component.color((TextColor)NamedTextColor.DARK_PURPLE).decorate(TextDecoration.BOLD);
    }

    public Component display_name(int level) {
        Component display_name = this.apply_display_format(this.lang_name.format(new Object[0]).decoration(TextDecoration.ITALIC, false));
        if (level != 1 || this.max_level() != 1) {
            Component chat_level = this.apply_display_format(Component.translatable((String)("enchantment.level." + level)).decoration(TextDecoration.ITALIC, false));
            display_name = display_name.append((Component)Component.text((String)" ")).append(chat_level);
        }
        return display_name;
    }

    public final int min_level() {
        return 1;
    }

    public final int max_level() {
        return this.annotation.max_level();
    }

    public int min_cost(int level) {
        return 1 + level * 10;
    }

    public int max_cost(int level) {
        return this.min_cost(level) + 5;
    }

    public final boolean is_treasure() {
        return this.annotation.treasure();
    }

    public final boolean is_tradeable() {
        return this.annotation.tradeable();
    }

    public final boolean is_curse() {
        return this.annotation.curse();
    }

    public final boolean generate_in_treasure() {
        return this.annotation.generate_in_treasure();
    }

    public final EnchantmentTarget target() {
        return this.annotation.target();
    }

    public final Rarity rarity() {
        return this.annotation.rarity();
    }

    public final boolean allow_custom() {
        return this.annotation.allow_custom();
    }

    public boolean is_compatible(@NotNull Enchantment other) {
        return true;
    }

    public boolean can_enchant(@NotNull ItemStack item_stack) {
        return this.annotation.target().includes(item_stack);
    }

    public RecipeList default_recipes() {
        return RecipeList.of(new RecipeDefinition[0]);
    }

    public LootTableList default_loot_tables() {
        return LootTableList.of(new LootDefinition[0]);
    }

    protected String on(String item_definition) {
        return this.on(item_definition, 1);
    }

    protected String on(String item_definition, int level) {
        return item_definition + "#enchants{" + String.valueOf(this.key) + "*" + level + "}";
    }
}

