/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.enchantments;

import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.StorageUtil;

public class EnchantmentManager
extends Listener<Core> {
    private static final NamespacedKey SENTINEL = StorageUtil.namespaced_key("vane", "enchantment_lore");

    public EnchantmentManager(Context<Core> context) {
        super(context);
    }

    public ItemStack update_enchanted_item(ItemStack item_stack) {
        return this.update_enchanted_item(item_stack, new HashMap<Enchantment, Integer>(), false);
    }

    public ItemStack update_enchanted_item(ItemStack item_stack, Map<Enchantment, Integer> additional_enchantments) {
        return this.update_enchanted_item(item_stack, additional_enchantments, false);
    }

    public ItemStack update_enchanted_item(ItemStack item_stack, boolean only_if_enchanted) {
        return this.update_enchanted_item(item_stack, new HashMap<Enchantment, Integer>(), only_if_enchanted);
    }

    public ItemStack update_enchanted_item(ItemStack item_stack, Map<Enchantment, Integer> additional_enchantments, boolean only_if_enchanted) {
        this.remove_old_lore(item_stack);
        return item_stack;
    }

    private void remove_superseded(ItemStack item_stack, Map<Enchantment, Integer> enchantments) {
    }

    private void remove_old_lore(ItemStack item_stack) {
        ArrayList<Component> lore = item_stack.lore();
        if (lore == null) {
            lore = new ArrayList<Component>();
        }
        lore.removeIf(this::is_enchantment_lore);
        item_stack.lore(lore.isEmpty() ? null : lore);
    }

    private boolean is_enchantment_lore(Component component) {
        TranslatableComponent translatable_component;
        if (component instanceof TranslatableComponent && (translatable_component = (TranslatableComponent)component).key().startsWith("vane_enchantments.")) {
            return true;
        }
        return ItemUtil.has_sentinel(component, SENTINEL);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_prepare_enchanted_edit(PrepareResultEvent event) {
        if (event.getResult() == null) {
            return;
        }
        event.setResult(this.update_enchanted_item(event.getResult().clone()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void on_enchant_item(EnchantItemEvent event) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>(event.getEnchantsToAdd());
        this.update_enchanted_item(event.getItem(), map);
    }

    private MerchantRecipe process_recipe(MerchantRecipe recipe) {
        ItemStack result = recipe.getResult().clone();
        MerchantRecipe new_recipe = new MerchantRecipe(this.update_enchanted_item(result, true), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier());
        recipe.getIngredients().forEach(i -> new_recipe.addIngredient(i));
        return new_recipe;
    }
}

