/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.oddlama.vane.annotation.config.ConfigInt;
import org.oddlama.vane.annotation.item.VaneItem;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.config.loot.LootDefinition;
import org.oddlama.vane.core.config.loot.LootTableList;
import org.oddlama.vane.core.config.loot.LootTables;
import org.oddlama.vane.core.config.recipes.RecipeDefinition;
import org.oddlama.vane.core.config.recipes.RecipeList;
import org.oddlama.vane.core.config.recipes.Recipes;
import org.oddlama.vane.core.lang.TranslatedMessage;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.util.StorageUtil;

public class CustomItem<T extends Module<T>>
extends Listener<T>
implements org.oddlama.vane.core.item.api.CustomItem {
    private VaneItem annotation;
    public NamespacedKey key;
    public Recipes<T> recipes;
    public LootTables<T> loot_tables;
    @LangMessage
    public TranslatedMessage lang_name;
    @ConfigInt(def=0, min=0, desc="The durability of this item. Set to 0 to use the durability properties of whatever base material the item is made of.")
    private int config_durability;
    private final String name_override;
    private final Integer custom_model_data_override;

    public CustomItem(Context<T> context) {
        this(context, null, null);
    }

    public CustomItem(Context<T> context, String name_override, Integer custom_model_data_override) {
        super(null);
        for (Class<?> cls = this.getClass(); this.annotation == null && cls != null; cls = cls.getSuperclass()) {
            this.annotation = cls.getAnnotation(VaneItem.class);
        }
        if (this.annotation == null) {
            throw new IllegalStateException("Could not find @VaneItem annotation on " + String.valueOf(this.getClass()));
        }
        this.name_override = name_override;
        this.custom_model_data_override = custom_model_data_override;
        context = context.group("item_" + this.name(), "Enable item " + this.name());
        this.set_context(context);
        this.key = StorageUtil.namespaced_key(((Module)this.get_module()).namespace(), this.name());
        this.recipes = new Recipes(this.get_context(), this.key, this::default_recipes);
        this.loot_tables = new LootTables(this.get_context(), this.key, this::default_loot_tables);
        ((Module)this.get_module()).core.item_registry().register(this);
    }

    @Override
    public NamespacedKey key() {
        return this.key;
    }

    public String name() {
        if (this.name_override != null) {
            return this.name_override;
        }
        return this.annotation.name();
    }

    @Override
    public boolean enabled() {
        return this.annotation.enabled() && super.enabled();
    }

    @Override
    public int version() {
        return this.annotation.version();
    }

    @Override
    public Material baseMaterial() {
        return this.annotation.base();
    }

    @Override
    public int customModelData() {
        if (this.custom_model_data_override != null) {
            return this.custom_model_data_override;
        }
        return this.annotation.model_data();
    }

    @Override
    public Component displayName() {
        return this.lang_name.format(new Object[0]).decoration(TextDecoration.ITALIC, false);
    }

    public int config_durability_def() {
        return this.annotation.durability();
    }

    @Override
    public int durability() {
        return this.config_durability;
    }

    public RecipeList default_recipes() {
        return RecipeList.of(new RecipeDefinition[0]);
    }

    public LootTableList default_loot_tables() {
        return LootTableList.of(new LootDefinition[0]);
    }
}

