/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.item.DurabilityManager;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;
import org.oddlama.vane.util.StorageUtil;

public class CustomItemHelper {
    public static final NamespacedKey CUSTOM_ITEM_IDENTIFIER = StorageUtil.namespaced_key("vane", "custom_item_identifier");
    public static final NamespacedKey CUSTOM_ITEM_VERSION = StorageUtil.namespaced_key("vane", "custom_item_version");

    public static ItemStack updateItemStack(CustomItem customItem, @NotNull ItemStack itemStack) {
        itemStack.editMeta(meta -> {
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(CUSTOM_ITEM_IDENTIFIER, PersistentDataType.STRING, (Object)customItem.key().toString());
            data.set(CUSTOM_ITEM_VERSION, PersistentDataType.INTEGER, (Object)customItem.version());
            meta.setCustomModelData(Integer.valueOf(customItem.customModelData()));
        });
        DurabilityManager.initialize_or_update_max(customItem, itemStack);
        return customItem.updateItemStack(itemStack);
    }

    public static Pair<NamespacedKey, Integer> customItemTagsFromItemStack(@Nullable ItemStack itemStack) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return null;
        }
        PersistentDataContainer data = itemStack.getItemMeta().getPersistentDataContainer();
        String key = (String)data.get(CUSTOM_ITEM_IDENTIFIER, PersistentDataType.STRING);
        Integer version = (Integer)data.get(CUSTOM_ITEM_VERSION, PersistentDataType.INTEGER);
        if (key == null || version == null) {
            return null;
        }
        String[] parts = key.split(":");
        if (parts.length != 2) {
            throw new IllegalStateException("Invalid namespaced key '" + key + "'");
        }
        return Pair.of(StorageUtil.namespaced_key(parts[0], parts[1]), version);
    }

    public static ItemStack newStack(String custom_item_key) {
        return CustomItemHelper.newStack(custom_item_key, 1);
    }

    public static ItemStack newStack(String custom_item_key, int amount) {
        return CustomItemHelper.newStack(Core.instance().item_registry().get(NamespacedKey.fromString((String)custom_item_key)), amount);
    }

    public static ItemStack newStack(CustomItem customItem) {
        return CustomItemHelper.newStack(customItem, 1);
    }

    public static ItemStack newStack(CustomItem customItem, int amount) {
        ItemStack itemStack = new ItemStack(customItem.baseMaterial(), amount);
        itemStack.editMeta(meta -> meta.itemName(customItem.displayName()));
        return CustomItemHelper.updateItemStack(customItem, itemStack);
    }

    public static ItemStack convertExistingStack(CustomItem customItem, ItemStack itemStack) {
        itemStack = itemStack.clone().withType(customItem.baseMaterial());
        return CustomItemHelper.updateItemStack(customItem, itemStack);
    }
}

