/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.item.CustomItemHelper;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.item.api.CustomModelDataRegistry;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;

public class CustomItemRegistry
implements org.oddlama.vane.core.item.api.CustomItemRegistry {
    private final HashMap<NamespacedKey, CustomItem> items = new HashMap();
    private final HashSet<NamespacedKey> items_to_remove = new HashSet();
    private CustomModelDataRegistry model_data_registry = Core.instance().model_data_registry();

    @Override
    @Nullable
    public boolean has(NamespacedKey resourceKey) {
        return this.items.containsKey(resourceKey);
    }

    @Override
    @Nullable
    public Collection<CustomItem> all() {
        return this.items.values();
    }

    @Override
    @Nullable
    public CustomItem get(NamespacedKey resourceKey) {
        return this.items.get(resourceKey);
    }

    @Override
    @Nullable
    public CustomItem get(@Nullable ItemStack itemStack) {
        Pair<NamespacedKey, Integer> key_and_version = CustomItemHelper.customItemTagsFromItemStack(itemStack);
        if (key_and_version == null) {
            return null;
        }
        return this.get(key_and_version.getLeft());
    }

    @Override
    public void register(CustomItem customItem) {
        this.model_data_registry.reserveSingle(customItem.key(), customItem.customModelData());
        if (this.has(customItem.key())) {
            throw new IllegalArgumentException("A custom item with the same key '" + String.valueOf(customItem.key()) + "' has already been registered");
        }
        this.items.put(customItem.key(), customItem);
    }

    @Override
    public void removePermanently(NamespacedKey key) {
        this.items_to_remove.add(key);
    }

    @Override
    public boolean shouldRemove(NamespacedKey key) {
        return this.items_to_remove.contains(key);
    }

    @Override
    public CustomModelDataRegistry dataRegistry() {
        return this.model_data_registry;
    }
}

