/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.item.api.CustomModelDataRegistry;

public class CustomModelDataRegistry
implements org.oddlama.vane.core.item.api.CustomModelDataRegistry {
    private final HashMap<NamespacedKey, CustomModelDataRegistry.Range> reserved_ranges = new HashMap();

    @Override
    public boolean has(int data) {
        return this.reserved_ranges.values().stream().anyMatch(r -> r.contains(data));
    }

    @Override
    public boolean hasAny(CustomModelDataRegistry.Range range) {
        return this.reserved_ranges.values().stream().anyMatch(r -> r.overlaps(range));
    }

    @Override
    @Nullable
    public CustomModelDataRegistry.Range get(NamespacedKey resourceKey) {
        return this.reserved_ranges.get(resourceKey);
    }

    @Override
    @Nullable
    public NamespacedKey get(int data) {
        for (Map.Entry<NamespacedKey, CustomModelDataRegistry.Range> kv : this.reserved_ranges.entrySet()) {
            if (!kv.getValue().contains(data)) continue;
            return kv.getKey();
        }
        return null;
    }

    @Override
    @Nullable
    public NamespacedKey get(CustomModelDataRegistry.Range range) {
        for (Map.Entry<NamespacedKey, CustomModelDataRegistry.Range> kv : this.reserved_ranges.entrySet()) {
            if (!kv.getValue().overlaps(range)) continue;
            return kv.getKey();
        }
        return null;
    }

    @Override
    public void reserve(NamespacedKey resourceKey, CustomModelDataRegistry.Range range) {
        NamespacedKey existing = this.get(range);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot reserve range " + String.valueOf(range) + ", already registered by " + String.valueOf(existing));
        }
        this.reserved_ranges.put(resourceKey, range);
    }

    @Override
    public void reserveSingle(NamespacedKey resourceKey, int data) {
        NamespacedKey existing = this.get(data);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot reserve customModelData " + data + ", already registered by " + String.valueOf(existing));
        }
        this.reserved_ranges.put(resourceKey, new CustomModelDataRegistry.Range(data, data + 1));
    }
}

