/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.StorageUtil;

public class DurabilityManager
extends Listener<Core> {
    public static final NamespacedKey ITEM_DURABILITY_MAX = StorageUtil.namespaced_key("vane", "durability.max");
    public static final NamespacedKey ITEM_DURABILITY_DAMAGE = StorageUtil.namespaced_key("vane", "durability.damage");
    private static final NamespacedKey SENTINEL = StorageUtil.namespaced_key("vane", "durability_override_lore");

    public DurabilityManager(Context<Core> context) {
        super(context);
    }

    private static boolean is_durability_lore(Component component) {
        return ItemUtil.has_sentinel(component, SENTINEL);
    }

    private static void remove_lore(ItemStack item_stack) {
        List lore = item_stack.lore();
        if (lore != null) {
            lore.removeIf(DurabilityManager::is_durability_lore);
            if (lore.size() > 0) {
                item_stack.lore(lore);
            } else {
                item_stack.lore(null);
            }
        }
    }

    private static void set_damage_and_update_item(CustomItem custom_item, ItemStack item_stack, int damage) {
        ItemMeta ro_meta = item_stack.getItemMeta();
        if (ro_meta.isUnbreakable()) {
            damage = 0;
        }
        DurabilityManager.set_damage_and_max_damage(custom_item, item_stack, damage);
    }

    public static boolean initialize_or_update_max(CustomItem custom_item, ItemStack item_stack) {
        int actual_damage;
        Integer old_damage = (Integer)item_stack.getItemMeta().getPersistentDataContainer().getOrDefault(ITEM_DURABILITY_DAMAGE, PersistentDataType.INTEGER, (Object)-1);
        item_stack.editMeta(meta -> {
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.remove(ITEM_DURABILITY_DAMAGE);
            data.remove(ITEM_DURABILITY_MAX);
        });
        if (custom_item.durability() <= 0) {
            DurabilityManager.remove_lore(item_stack);
            return false;
        }
        if (old_damage == -1) {
            ItemMeta itemMeta = item_stack.getItemMeta();
            if (itemMeta instanceof Damageable) {
                Damageable damage_meta = (Damageable)itemMeta;
                short visual_max = item_stack.getType().getMaxDurability();
                double damage_percentage = (double)damage_meta.getDamage() / (double)visual_max;
                actual_damage = (int)((double)custom_item.durability() * damage_percentage);
            } else {
                actual_damage = 0;
            }
        } else {
            actual_damage = old_damage;
        }
        DurabilityManager.set_damage_and_update_item(custom_item, item_stack, actual_damage);
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_item_damage(PlayerItemDamageEvent event) {
        ItemStack item = event.getItem();
        CustomItem custom_item = ((Core)this.get_module()).item_registry().get(item);
        if (custom_item == null) {
            return;
        }
        DurabilityManager.update_damage(custom_item, item);
    }

    public static void update_damage(CustomItem custom_item, ItemStack item_stack) {
        int old_max_damage;
        int old_damage;
        int new_max_damage;
        ItemMeta itemMeta = item_stack.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return;
        }
        Damageable meta = (Damageable)itemMeta;
        boolean updated = false;
        PersistentDataContainer data = meta.getPersistentDataContainer();
        int n = new_max_damage = custom_item.durability() == 0 ? (int)item_stack.getType().getMaxDurability() : custom_item.durability();
        if (data.has(ITEM_DURABILITY_DAMAGE) && data.has(ITEM_DURABILITY_MAX)) {
            old_damage = (Integer)data.get(ITEM_DURABILITY_DAMAGE, PersistentDataType.INTEGER);
            old_max_damage = (Integer)data.get(ITEM_DURABILITY_MAX, PersistentDataType.INTEGER);
            updated = true;
        } else {
            old_damage = meta.hasDamage() ? meta.getDamage() : 0;
            old_max_damage = meta.hasMaxDamage() ? meta.getMaxDamage() : (int)item_stack.getType().getMaxDurability();
        }
        item_stack.editMeta(Damageable.class, imeta -> {
            PersistentDataContainer idata = imeta.getPersistentDataContainer();
            idata.remove(ITEM_DURABILITY_DAMAGE);
            idata.remove(ITEM_DURABILITY_MAX);
        });
        DurabilityManager.remove_lore(item_stack);
        if (!updated) {
            boolean bl = updated = old_max_damage != new_max_damage;
        }
        if (!updated) {
            return;
        }
        int new_damage = DurabilityManager.scale_damage(old_damage, old_max_damage, new_max_damage);
        DurabilityManager.set_damage_and_max_damage(custom_item, item_stack, new_damage);
    }

    public static int scale_damage(int old_damage, int old_max_damage, int new_max_damage) {
        return old_max_damage == new_max_damage ? old_damage : (int)((float)new_max_damage * ((float)old_damage / (float)old_max_damage));
    }

    public static boolean set_damage_and_max_damage(CustomItem custom_item, ItemStack item, int damage) {
        return item.editMeta(Damageable.class, meta -> {
            if (custom_item.durability() != 0) {
                meta.setMaxDamage(Integer.valueOf(custom_item.durability()));
            } else {
                meta.setMaxDamage(Integer.valueOf(item.getType().getMaxDurability()));
            }
            meta.setDamage(damage);
        });
    }
}

