/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.item.CustomItemHelper;
import org.oddlama.vane.core.item.DurabilityManager;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.external.apache.commons.lang3.tuple.Pair;

public class ExistingItemConverter
extends Listener<Core> {
    public ExistingItemConverter(Context<Core> context) {
        super(context.namespace("existing_item_converter"));
    }

    private CustomItem from_old_item(ItemStack item_stack) {
        String new_item_key;
        List modelDataList = item_stack.getItemMeta().getCustomModelDataComponent().getFloats();
        if (modelDataList.isEmpty() || modelDataList.getFirst() == null) {
            return null;
        }
        switch (((Float)modelDataList.getFirst()).intValue()) {
            case 7758190: {
                String string = "vane_trifles:wooden_sickle";
                break;
            }
            case 7758191: {
                String string = "vane_trifles:stone_sickle";
                break;
            }
            case 7758192: {
                String string = "vane_trifles:iron_sickle";
                break;
            }
            case 0x766171: {
                String string = "vane_trifles:golden_sickle";
                break;
            }
            case 7758194: {
                String string = "vane_trifles:diamond_sickle";
                break;
            }
            case 7758195: {
                String string = "vane_trifles:netherite_sickle";
                break;
            }
            case 7758254: 
            case 7758255: 
            case 7758256: 
            case 7758257: 
            case 7758258: 
            case 7758259: {
                String string = "vane_trifles:file";
                break;
            }
            case 7758318: {
                String string = "vane_trifles:empty_xp_bottle";
                break;
            }
            case 7758382: {
                String string = "vane_trifles:small_xp_bottle";
                break;
            }
            case 7758383: {
                String string = "vane_trifles:medium_xp_bottle";
                break;
            }
            case 7758384: {
                String string = "vane_trifles:large_xp_bottle";
                break;
            }
            case 7758446: {
                String string = "vane_trifles:home_scroll";
                break;
            }
            case 7758510: {
                String string = "vane_trifles:unstable_scroll";
                break;
            }
            case 7758574: {
                String string = "vane_trifles:reinforced_elytra";
                break;
            }
            case 7823726: {
                String string = "vane_enchantments:ancient_tome";
                break;
            }
            case 7823727: {
                String string = "vane_enchantments:enchanted_ancient_tome";
                break;
            }
            case 7823790: {
                String string = "vane_enchantments:ancient_tome_of_knowledge";
                break;
            }
            case 7823791: {
                String string = "vane_enchantments:enchanted_ancient_tome_of_knowledge";
                break;
            }
            case 7823854: {
                String string = "vane_enchantments:ancient_tome_of_the_gods";
                break;
            }
            case 7823855: {
                String string = "vane_enchantments:enchanted_ancient_tome_of_the_gods";
                break;
            }
            default: {
                String string = new_item_key = null;
            }
        }
        if (new_item_key == null) {
            return null;
        }
        return ((Core)this.get_module()).item_registry().get(NamespacedKey.fromString((String)new_item_key));
    }

    private void process_inventory(@NotNull Inventory inventory) {
        ItemStack[] contents = inventory.getContents();
        int changed = 0;
        for (int i = 0; i < contents.length; ++i) {
            int correct_max_damage;
            ItemStack is = contents[i];
            if (is == null || !is.hasItemMeta()) continue;
            CustomItem custom_item = ((Core)this.get_module()).item_registry().get(is);
            if (custom_item == null) {
                CustomItem convert_to_custom_item = this.from_old_item(is);
                if (convert_to_custom_item == null) continue;
                contents[i] = convert_to_custom_item.convertExistingStack(is);
                contents[i].editMeta(meta -> meta.itemName(convert_to_custom_item.displayName()));
                ((Core)this.get_module()).enchantment_manager.update_enchanted_item(contents[i]);
                ((Core)this.get_module()).log.info("Converted legacy item to " + String.valueOf(convert_to_custom_item.key()));
                ++changed;
                continue;
            }
            if (((Core)this.get_module()).item_registry().shouldRemove(custom_item.key())) {
                contents[i] = null;
                ((Core)this.get_module()).log.info("Removed obsolete item " + String.valueOf(custom_item.key()));
                ++changed;
                continue;
            }
            Pair<NamespacedKey, Integer> key_and_version = CustomItemHelper.customItemTagsFromItemStack(is);
            ItemMeta meta2 = is.getItemMeta();
            if (meta2.getCustomModelData() != custom_item.customModelData() || is.getType() != custom_item.baseMaterial() || key_and_version.getRight().intValue() != custom_item.version()) {
                contents[i] = custom_item.convertExistingStack(is);
                ((Core)this.get_module()).log.info("Updated item " + String.valueOf(custom_item.key()));
                ++changed;
                continue;
            }
            Damageable damageableMeta = (Damageable)contents[i].getItemMeta();
            int max_damage = damageableMeta.hasMaxDamage() ? damageableMeta.getMaxDamage() : (int)contents[i].getType().getMaxDurability();
            int n = correct_max_damage = custom_item.durability() == 0 ? (int)contents[i].getType().getMaxDurability() : custom_item.durability();
            if (max_damage == correct_max_damage && !meta2.getPersistentDataContainer().has(DurabilityManager.ITEM_DURABILITY_DAMAGE)) continue;
            ((Core)this.get_module()).log.info("Updated item durability " + String.valueOf(custom_item.key()));
            DurabilityManager.update_damage(custom_item, contents[i]);
            ++changed;
        }
        if (changed > 0) {
            inventory.setContents(contents);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_player_join(PlayerJoinEvent event) {
        this.process_inventory((Inventory)event.getPlayer().getInventory());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void on_inventory_open(InventoryOpenEvent event) {
        this.process_inventory(event.getInventory());
    }
}

