/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item;

import net.minecraft.core.component.DataComponentMap;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingRecipe;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.Listener;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.item.api.InhibitBehavior;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.MaterialUtil;

public class VanillaFunctionalityInhibitor
extends Listener<Core> {
    public VanillaFunctionalityInhibitor(Context<Core> context) {
        super(context);
    }

    private boolean inhibit(CustomItem custom_item, InhibitBehavior behavior) {
        return custom_item != null && custom_item.enabled() && custom_item.inhibitedBehaviors().contains((Object)behavior);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void on_pathfind(EntityTargetEvent event) {
        if (event.getReason() != EntityTargetEvent.TargetReason.TEMPT) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CustomItem custom_item_main = ((Core)this.get_module()).item_registry().get(player.getInventory().getItemInMainHand());
            CustomItem custom_item_off = ((Core)this.get_module()).item_registry().get(player.getInventory().getItemInOffHand());
            if (this.inhibit(custom_item_main, InhibitBehavior.TEMPT) || this.inhibit(custom_item_off, InhibitBehavior.TEMPT)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_hoe_right_click_block(PlayerInteractEvent event) {
        if (!event.hasBlock() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!MaterialUtil.is_tillable(event.getClickedBlock().getType())) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getEquipment().getItem(event.getHand());
        if (this.inhibit(((Core)this.get_module()).item_registry().get(item), InhibitBehavior.HOE_TILL)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_prepare_item_craft(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (!(recipe instanceof Keyed)) {
            return;
        }
        Keyed keyed = (Keyed)recipe;
        if (!keyed.getKey().getNamespace().equals("minecraft")) {
            return;
        }
        for (ItemStack item : event.getInventory().getMatrix()) {
            if (!this.inhibit(((Core)this.get_module()).item_registry().get(item), InhibitBehavior.USE_IN_VANILLA_RECIPE)) continue;
            event.getInventory().setResult(null);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_prepare_smithing(PrepareSmithingEvent event) {
        ItemStack item = event.getInventory().getInputEquipment();
        Recipe recipe = event.getInventory().getRecipe();
        if (!(recipe instanceof Keyed)) {
            return;
        }
        Keyed keyed = (Keyed)recipe;
        if (!keyed.getKey().getNamespace().equals("minecraft")) {
            return;
        }
        if (this.inhibit(((Core)this.get_module()).item_registry().get(item), InhibitBehavior.USE_IN_VANILLA_RECIPE)) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_prepare_smithing_copy_nbt(PrepareSmithingEvent event) {
        SmithingRecipe smithing_recipe;
        ItemStack result = event.getResult();
        Recipe recipe = event.getInventory().getRecipe();
        if (result == null || !(recipe instanceof SmithingRecipe) || !(smithing_recipe = (SmithingRecipe)recipe).willCopyNbt()) {
            return;
        }
        result = recipe.getResult();
        CustomItem custom_item_result = ((Core)this.get_module()).item_registry().get(result);
        if (custom_item_result == null) {
            return;
        }
        ItemStack input = event.getInventory().getInputEquipment();
        DataComponentMap input_components = CraftItemStack.asNMSCopy((ItemStack)input).getComponents();
        net.minecraft.world.item.ItemStack nms_result = CraftItemStack.asNMSCopy((ItemStack)result);
        nms_result.applyComponents(input_components);
        event.setResult(custom_item_result.convertExistingStack((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nms_result)));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_prepare_anvil(PrepareAnvilEvent event) {
        ItemStack r;
        ItemStack a = event.getInventory().getFirstItem();
        ItemStack b = event.getInventory().getSecondItem();
        if (a != null && b != null && a.getType() == b.getType()) {
            CustomItem custom_item_a = ((Core)this.get_module()).item_registry().get(a);
            CustomItem custom_item_b = ((Core)this.get_module()).item_registry().get(b);
            if (custom_item_a != null && custom_item_a != custom_item_b) {
                event.setResult(null);
                return;
            }
        }
        if ((r = event.getInventory().getResult()) != null) {
            CustomItem custom_item_r = ((Core)this.get_module()).item_registry().get(r);
            boolean[] did_edit = new boolean[]{true};
            r.editMeta(meta -> {
                if (a != null && this.inhibit(custom_item_r, InhibitBehavior.NEW_ENCHANTS)) {
                    for (Enchantment ench : r.getEnchantments().keySet()) {
                        if (a.getEnchantments().containsKey(ench)) continue;
                        meta.removeEnchant(ench);
                        did_edit[0] = true;
                    }
                }
                if (this.inhibit(custom_item_r, InhibitBehavior.MEND)) {
                    meta.removeEnchant(Enchantment.MENDING);
                    did_edit[0] = true;
                }
            });
            if (did_edit[0]) {
                event.setResult(r);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_item_mend(PlayerItemMendEvent event) {
        ItemStack item = event.getItem();
        CustomItem custom_item = ((Core)this.get_module()).item_registry().get(item);
        if (this.inhibit(custom_item, InhibitBehavior.MEND)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void on_item_burn(EntityDamageEvent event) {
        if (event.getEntity().getType() != EntityType.ITEM) {
            return;
        }
        switch (event.getCause()) {
            default: {
                return;
            }
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: 
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        ItemStack item = ((Item)entity).getItemStack();
        if (this.inhibit(((Core)this.get_module()).item_registry().get(item), InhibitBehavior.ITEM_BURN)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_player_right_click(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack main_item = player.getEquipment().getItem(EquipmentSlot.HAND);
        CustomItem main_custom_item = ((Core)this.get_module()).item_registry().get(main_item);
        if (this.inhibit(main_custom_item, InhibitBehavior.USE_OFFHAND)) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void on_dispense(BlockDispenseEvent event) {
        if (event.getBlock().getType() != Material.DISPENSER) {
            return;
        }
        CustomItem custom_item = ((Core)this.get_module()).item_registry().get(event.getItem());
        if (this.inhibit(custom_item, InhibitBehavior.DISPENSE)) {
            event.setCancelled(true);
        }
    }
}

