/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.item.api;

import java.util.EnumSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.oddlama.vane.core.item.CustomItemHelper;
import org.oddlama.vane.core.item.api.CustomItemRegistry;
import org.oddlama.vane.core.item.api.InhibitBehavior;

public interface CustomItem {
    public NamespacedKey key();

    public boolean enabled();

    public int version();

    public Material baseMaterial();

    public int customModelData();

    @Nullable
    public Component displayName();

    @Nullable
    default public TranslatableComponent durabilityLore() {
        return (TranslatableComponent)((TranslatableComponent)Component.translatable((String)"item.durability").color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false);
    }

    public int durability();

    default public EnumSet<InhibitBehavior> inhibitedBehaviors() {
        return EnumSet.of(InhibitBehavior.USE_IN_VANILLA_RECIPE);
    }

    default public ItemStack updateItemStack(@NotNull ItemStack itemStack) {
        return itemStack;
    }

    default public boolean isInstance(@Nullable ItemStack itemStack) {
        return CustomItemRegistry.instance().get(itemStack) == this;
    }

    default public ItemStack newStack() {
        return CustomItemHelper.newStack(this);
    }

    default public ItemStack newStack(int amount) {
        return CustomItemHelper.newStack(this, amount);
    }

    default public ItemStack convertExistingStack(ItemStack item_stack) {
        return CustomItemHelper.convertExistingStack(this, item_stack);
    }
}

