/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.lang;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;

public abstract class LangField<T> {
    public static final String PREFIX = "lang_";
    private Module<?> module;
    protected Object owner;
    protected Field field;
    protected String name;
    private final String namespace;
    private final String key;

    public LangField(Module<?> module, Object owner, Field field, Function<String, String> map_name) {
        this.module = module;
        this.owner = owner;
        this.field = field;
        if (!field.getName().contains(PREFIX)) {
            throw new RuntimeException(new YamlLoadException.Lang("field must start with lang_", this));
        }
        this.name = map_name.apply(field.getName().substring(PREFIX.length()));
        this.namespace = module.namespace();
        this.key = this.namespace + "." + this.yaml_path();
        field.setAccessible(true);
    }

    public String get_name() {
        return this.name;
    }

    public String yaml_path() {
        return this.name;
    }

    protected void check_yaml_path(YamlConfiguration yaml) throws YamlLoadException {
        if (!yaml.contains(this.name, true)) {
            throw new YamlLoadException.Lang("yaml is missing entry with path '" + this.name + "'", this);
        }
    }

    public Module<?> module() {
        return this.module;
    }

    public String namespace() {
        return this.namespace;
    }

    public String key() {
        return this.key;
    }

    public abstract void check_loadable(YamlConfiguration var1) throws YamlLoadException;

    public abstract void load(String var1, YamlConfiguration var2);

    public abstract void add_translations(ResourcePackGenerator var1, YamlConfiguration var2, String var3) throws YamlLoadException;

    public T get() {
        try {
            return (T)this.field.get(this.owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }

    public String toString() {
        return this.field.getDeclaringClass().getTypeName() + "::" + this.field.getName();
    }
}

