/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.lang;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.lang.LangMessage;
import org.oddlama.vane.annotation.lang.LangMessageArray;
import org.oddlama.vane.annotation.lang.LangVersion;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.lang.LangField;
import org.oddlama.vane.core.lang.LangMessageArrayField;
import org.oddlama.vane.core.lang.LangMessageField;
import org.oddlama.vane.core.lang.LangVersionField;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;
import org.oddlama.vane.external.reflections.ReflectionUtils;

public class LangManager {
    Module<?> module;
    private List<LangField<?>> lang_fields = new ArrayList();
    LangVersionField field_version;

    public LangManager(Module<?> module) {
        this.module = module;
        this.compile(module, s -> s);
    }

    public long expected_version() {
        return this.module.annotation.lang_version();
    }

    private boolean has_lang_annotation(Field field) {
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getName().startsWith("org.oddlama.vane.annotation.lang.Lang")) continue;
            return true;
        }
        return false;
    }

    private void assert_field_prefix(Field field) {
        if (!field.getName().startsWith("lang_")) {
            throw new RuntimeException("Language fields must be prefixed lang_. This is a bug.");
        }
    }

    private LangField<?> compile_field(Object owner, Field field, Function<String, String> map_name) {
        this.assert_field_prefix(field);
        Annotation annotation = null;
        for (Annotation a : field.getAnnotations()) {
            if (!a.annotationType().getName().startsWith("org.oddlama.vane.annotation.lang.Lang")) continue;
            if (annotation == null) {
                annotation = a;
                continue;
            }
            throw new RuntimeException("Language fields must have exactly one @Lang annotation.");
        }
        assert (annotation != null);
        Class<? extends Annotation> atype = annotation.annotationType();
        if (atype.equals(LangMessage.class)) {
            return new LangMessageField(this.module, owner, field, map_name, (LangMessage)annotation);
        }
        if (atype.equals(LangMessageArray.class)) {
            return new LangMessageArrayField(this.module, owner, field, map_name, (LangMessageArray)annotation);
        }
        if (atype.equals(LangVersion.class)) {
            if (owner != this.module) {
                throw new RuntimeException("@LangVersion can only be used inside the main module. This is a bug.");
            }
            if (this.field_version != null) {
                throw new RuntimeException("There must be exactly one @LangVersion field! (found multiple). This is a bug.");
            }
            this.field_version = new LangVersionField(this.module, owner, field, map_name, (LangVersion)annotation);
            return this.field_version;
        }
        throw new RuntimeException("Missing LangField handler for @" + atype.getName() + ". This is a bug.");
    }

    private boolean verify_version(File file, long version) {
        if (version != this.expected_version()) {
            this.module.log.severe(file.getName() + ": expected version " + this.expected_version() + ", but got " + version);
            if (version == 0L) {
                this.module.log.severe("Something went wrong while generating or loading the configuration.");
                this.module.log.severe("If you are sure your configuration is correct and this isn't a file");
                this.module.log.severe("system permission issue, please report this to https://github.com/oddlama/vane/issues");
            } else if (version < this.expected_version()) {
                this.module.log.severe("This language file is for an older version of " + this.module.getName() + ".");
                this.module.log.severe("Please update your file or use an officially supported language file.");
            } else {
                this.module.log.severe("This language file is for a future version of " + this.module.getName() + ".");
                this.module.log.severe("Please use the correct file for this version, or use an officially");
                this.module.log.severe("supported language file.");
            }
            return false;
        }
        return true;
    }

    public void compile(Object owner, Function<String, String> map_name) {
        this.lang_fields.addAll(ReflectionUtils.getAllFields(owner.getClass(), new Predicate[0]).stream().filter(this::has_lang_annotation).map(f -> this.compile_field(owner, (Field)f, map_name)).toList());
        if (owner == this.module && this.field_version == null) {
            throw new RuntimeException("There must be exactly one @LangVersion field! (found none). This is a bug.");
        }
    }

    public <T> T get_field(String name) {
        LangField field = this.lang_fields.stream().filter(f -> f.get_name().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("Missing lang field lang_" + name));
        try {
            return (T)field;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Invalid lang field type for lang_" + name, e);
        }
    }

    public boolean reload(File file) {
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
        long version = yaml.getLong("version", -1L);
        if (!this.verify_version(file, version)) {
            return false;
        }
        try {
            for (LangField<?> f : this.lang_fields) {
                f.check_loadable(yaml);
            }
            for (LangField<?> f : this.lang_fields) {
                f.load(this.module.namespace(), yaml);
            }
        }
        catch (YamlLoadException e) {
            this.module.log.log(Level.SEVERE, "error while loading '" + file.getAbsolutePath() + "'", e);
            return false;
        }
        return true;
    }

    public void generate_resource_pack(ResourcePackGenerator pack, YamlConfiguration yaml, File lang_file) {
        String lang_code = yaml.getString("resource_pack_lang_code");
        if (lang_code == null) {
            throw new RuntimeException("Missing yaml key: resource_pack_lang_code");
        }
        LinkedList<YamlLoadException.Lang> errors = new LinkedList<YamlLoadException.Lang>();
        for (LangField<?> f : this.lang_fields) {
            try {
                f.add_translations(pack, yaml, lang_code);
            }
            catch (YamlLoadException.Lang e) {
                errors.add(e);
            }
            catch (YamlLoadException e) {
                this.module.log.log(Level.SEVERE, "Unexpected YAMLLoadException: ", e);
            }
        }
        if (errors.size() > 0) {
            String errored_lang_nodes = errors.stream().map(Throwable::getMessage).collect(Collectors.joining("\n\t\t"));
            this.module.log.log(Level.SEVERE, "The following errors were identified while adding translations from \n\t" + lang_file.getAbsolutePath() + " \n\t\t" + errored_lang_nodes);
        }
    }
}

