/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.lang;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.configuration.file.YamlConfiguration;
import org.oddlama.vane.annotation.lang.LangMessageArray;
import org.oddlama.vane.core.YamlLoadException;
import org.oddlama.vane.core.lang.LangField;
import org.oddlama.vane.core.lang.TranslatedMessageArray;
import org.oddlama.vane.core.module.Module;
import org.oddlama.vane.core.resourcepack.ResourcePackGenerator;

public class LangMessageArrayField
extends LangField<TranslatedMessageArray> {
    public LangMessageArray annotation;

    public LangMessageArrayField(Module<?> module, Object owner, Field field, Function<String, String> map_name, LangMessageArray annotation) {
        super(module, owner, field, map_name);
        this.annotation = annotation;
    }

    @Override
    public void check_loadable(YamlConfiguration yaml) throws YamlLoadException {
        this.check_yaml_path(yaml);
        if (!yaml.isList(this.yaml_path())) {
            throw new YamlLoadException.Lang("Invalid type for yaml path '" + this.yaml_path() + "', expected list", this);
        }
        for (Object obj : yaml.getList(this.yaml_path())) {
            if (obj instanceof String) continue;
            throw new YamlLoadException.Lang("Invalid type for yaml path '" + this.yaml_path() + "', expected string", this);
        }
    }

    private List<String> from_yaml(YamlConfiguration yaml) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object obj : yaml.getList(this.yaml_path())) {
            list.add((String)obj);
        }
        return list;
    }

    @Override
    public void load(String namespace, YamlConfiguration yaml) {
        try {
            this.field.set(this.owner, new TranslatedMessageArray(this.module(), this.key(), this.from_yaml(yaml)));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Invalid field access on '" + this.field.getName() + "'. This is a bug.");
        }
    }

    @Override
    public void add_translations(ResourcePackGenerator pack, YamlConfiguration yaml, String lang_code) throws YamlLoadException {
        this.check_loadable(yaml);
        List<String> list = this.from_yaml(yaml);
        int loaded_size = ((TranslatedMessageArray)this.get()).size();
        if (list.size() != loaded_size) {
            throw new YamlLoadException.Lang("All translation lists for message arrays must have the exact same size. The loaded language file has " + loaded_size + " entries, while the currently processed file has " + list.size(), this);
        }
        for (int i = 0; i < list.size(); ++i) {
            pack.translations(this.namespace(), lang_code).put(this.key() + "." + i, list.get(i));
        }
    }
}

