/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.lang;

import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.oddlama.vane.core.module.Module;

public class TranslatedMessage {
    private Module<?> module;
    private String key;
    private String default_translation;

    public TranslatedMessage(Module<?> module, String key, String default_translation) {
        this.module = module;
        this.key = key;
        this.default_translation = default_translation;
    }

    public String key() {
        return this.key;
    }

    public String str(Object ... args) {
        try {
            Object[] args_as_strings = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Component) {
                    args_as_strings[i] = LegacyComponentSerializer.legacySection().serialize((Component)args[i]);
                    continue;
                }
                if (args[i] instanceof String) {
                    args_as_strings[i] = args[i];
                    continue;
                }
                throw new RuntimeException("Error while formatting message '" + this.key() + "', invalid argument to str() serializer: " + String.valueOf(args[i]));
            }
            return String.format(this.default_translation, args_as_strings);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while formatting message '" + this.key() + "'", e);
        }
    }

    @NotNull
    public Component str_component(Object ... args) {
        return LegacyComponentSerializer.legacySection().deserialize(this.str(args));
    }

    public Component format(Object ... args) {
        if (!this.module.core.config_client_side_translations) {
            return this.str_component(args);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : args) {
            if (o instanceof ComponentLike) {
                list.add((ComponentLike)o);
                continue;
            }
            if (o instanceof String) {
                list.add(LegacyComponentSerializer.legacySection().deserialize((String)o));
                continue;
            }
            throw new RuntimeException("Error while formatting message '" + this.key() + "', got invalid argument " + String.valueOf(o));
        }
        return Component.translatable((String)this.key, list);
    }

    public void broadcast_server_players(Object ... args) {
        Component component = this.format(args);
        for (Player player : this.module.getServer().getOnlinePlayers()) {
            player.sendMessage(component);
        }
    }

    public void broadcast_server(Object ... args) {
        Component component = this.format(args);
        for (Player player : this.module.getServer().getOnlinePlayers()) {
            player.sendMessage(component);
        }
        this.module.clog.info(Component.text((String)"[broadcast] ").append(this.str_component(args)));
    }

    public void broadcast_world(World world, Object ... args) {
        Component component = this.format(args);
        for (Player player : world.getPlayers()) {
            player.sendMessage(component);
        }
    }

    public void broadcast_world_action_bar(World world, Object ... args) {
        Component component = this.format(args);
        for (Player player : world.getPlayers()) {
            player.sendActionBar(component);
        }
    }

    public void send(CommandSender sender, Object ... args) {
        if (sender == null || sender == this.module.getServer().getConsoleSender()) {
            this.module.getServer().getConsoleSender().sendMessage(this.str_component(args));
        } else {
            sender.sendMessage(this.format(args));
        }
    }

    public void send_action_bar(CommandSender sender, Object ... args) {
        if (sender != null && sender != this.module.getServer().getConsoleSender()) {
            sender.sendActionBar(this.format(args));
        }
    }

    public void send_and_log(CommandSender sender, Object ... args) {
        this.module.clog.info(this.str_component(args));
        if (sender != null && sender != this.module.getServer().getConsoleSender()) {
            sender.sendMessage(this.format(args));
        }
    }
}

