/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.oddlama.vane.core.module.Module;

public class TranslatedMessageArray {
    private Module<?> module;
    private String key;
    private List<String> default_translation;

    public TranslatedMessageArray(Module<?> module, String key, List<String> default_translation) {
        this.module = module;
        this.key = key;
        this.default_translation = default_translation;
    }

    public int size() {
        return this.default_translation.size();
    }

    public String key() {
        return this.key;
    }

    public List<String> str(Object ... args) {
        try {
            Object[] args_as_strings = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Component) {
                    args_as_strings[i] = LegacyComponentSerializer.legacySection().serialize((Component)args[i]);
                    continue;
                }
                if (args[i] instanceof String) {
                    args_as_strings[i] = args[i];
                    continue;
                }
                throw new RuntimeException("Error while formatting message '" + this.key() + "', invalid argument to str() serializer: " + String.valueOf(args[i]));
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String s : this.default_translation) {
                list.add(String.format(s, args_as_strings));
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while formatting message '" + this.key() + "'", e);
        }
    }

    public List<Component> format(Object ... args) {
        if (!this.module.core.config_client_side_translations) {
            return this.str(args).stream().map(s -> LegacyComponentSerializer.legacySection().deserialize(s)).collect(Collectors.toList());
        }
        ArrayList<Component> arr = new ArrayList<Component>();
        for (int i = 0; i < this.default_translation.size(); ++i) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : args) {
                if (o instanceof ComponentLike) {
                    list.add((ComponentLike)o);
                    continue;
                }
                if (o instanceof String) {
                    list.add(LegacyComponentSerializer.legacySection().deserialize((String)o));
                    continue;
                }
                throw new RuntimeException("Error while formatting message '" + this.key() + "', got invalid argument " + String.valueOf(o));
            }
            arr.add((Component)Component.translatable((String)(this.key + "." + i), list));
        }
        return arr;
    }
}

