/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.material;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.item.api.CustomItem;
import org.oddlama.vane.core.material.HeadMaterial;
import org.oddlama.vane.core.material.HeadMaterialLibrary;
import org.oddlama.vane.util.MaterialUtil;

public class ExtendedMaterial {
    private NamespacedKey key;
    private Material material;
    private HeadMaterial head_material;

    private ExtendedMaterial(NamespacedKey key) {
        this.key = key;
        this.material = MaterialUtil.material_from(key);
        this.head_material = this.material == null ? HeadMaterialLibrary.from(key) : null;
    }

    public NamespacedKey key() {
        return this.key;
    }

    public boolean is_simple_material() {
        return this.material != null;
    }

    public static ExtendedMaterial from(NamespacedKey key) {
        ExtendedMaterial mat = new ExtendedMaterial(key);
        if (mat.material == null && mat.head_material == null && key.namespace().equals("minecraft")) {
            return null;
        }
        return mat;
    }

    public static ExtendedMaterial from(Material material) {
        return ExtendedMaterial.from(material.getKey());
    }

    public static ExtendedMaterial from(CustomItem customItem) {
        return ExtendedMaterial.from(customItem.key());
    }

    public ItemStack item() {
        return this.item(1);
    }

    public ItemStack item(int amount) {
        if (this.head_material != null) {
            ItemStack item = this.head_material.item();
            item.setAmount(amount);
            return item;
        }
        if (this.material != null) {
            return new ItemStack(this.material, amount);
        }
        CustomItem custom_item = Core.instance().item_registry().get(this.key);
        if (custom_item == null) {
            throw new IllegalStateException("ExtendedMaterial '" + String.valueOf(this.key) + "' is neither a classic material, a head nor a custom item!");
        }
        return custom_item.newStack();
    }
}

