/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.material;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.external.json.JSONArray;
import org.oddlama.vane.external.json.JSONObject;
import org.oddlama.vane.util.ItemUtil;
import org.oddlama.vane.util.StorageUtil;

public class HeadMaterial {
    private NamespacedKey key;
    private String name;
    private String category;
    private Set<String> tags;
    private String base64_texture;

    public HeadMaterial(NamespacedKey key, String name, String category, List<String> tags, String base64_texture) {
        this.key = key;
        this.name = name;
        this.category = category;
        this.tags = new HashSet<String>(tags);
        this.base64_texture = base64_texture;
    }

    public NamespacedKey key() {
        return this.key;
    }

    public String name() {
        return this.name;
    }

    public String category() {
        return this.category;
    }

    public Set<String> tags() {
        return this.tags;
    }

    public String texture() {
        return this.base64_texture;
    }

    public ItemStack item() {
        return ItemUtil.skull_with_texture(this.name, this.base64_texture);
    }

    public static HeadMaterial from(JSONObject json) {
        String id = json.getString("id");
        String name = json.getString("name");
        String category = json.getString("category");
        String texture = json.getString("texture");
        ArrayList<String> tags = new ArrayList<String>();
        JSONArray tags_arr = json.getJSONArray("tags");
        for (int i = 0; i < tags_arr.length(); ++i) {
            tags.add(tags_arr.getString(i));
        }
        NamespacedKey key = StorageUtil.namespaced_key("vane", category + "_" + id);
        return new HeadMaterial(key, name, category, tags, texture);
    }
}

