/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.oddlama.vane.core.material.HeadMaterial;
import org.oddlama.vane.external.json.JSONArray;

public class HeadMaterialLibrary {
    private static final Map<NamespacedKey, HeadMaterial> registry = new HashMap<NamespacedKey, HeadMaterial>();
    private static final Map<String, List<HeadMaterial>> categories = new HashMap<String, List<HeadMaterial>>();
    private static final Map<String, List<HeadMaterial>> tags = new HashMap<String, List<HeadMaterial>>();
    private static final Map<String, HeadMaterial> by_texture = new HashMap<String, HeadMaterial>();

    public static void load(String string) {
        JSONArray json = new JSONArray(string);
        for (int i = 0; i < json.length(); ++i) {
            HeadMaterial mat = HeadMaterial.from(json.getJSONObject(i));
            registry.put(mat.key(), mat);
            by_texture.put(mat.texture(), mat);
            List category = categories.computeIfAbsent(mat.category(), k -> new ArrayList());
            category.add(mat);
            for (String tag : mat.tags()) {
                List tag_list = tags.computeIfAbsent(tag, k -> new ArrayList());
                tag_list.add(mat);
            }
        }
    }

    public static HeadMaterial from(NamespacedKey key) {
        return registry.get(key);
    }

    public static HeadMaterial from_texture(String base64_texture) {
        return by_texture.get(base64_texture);
    }

    public static Collection<HeadMaterial> all() {
        return registry.values();
    }
}

