/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenScreenPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import org.bukkit.entity.Player;
import org.oddlama.vane.core.Core;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.util.Nms;

public class AnvilMenu
extends Menu {
    private ServerPlayer entity;
    private AnvilContainer container;
    private int container_id;
    private String title;

    public AnvilMenu(Context<?> context, Player player, String title) {
        super(context);
        this.title = title;
        this.entity = Nms.player_handle(player);
        this.container_id = this.entity.nextContainerCounter();
        this.container = new AnvilContainer(this, this.container_id, (net.minecraft.world.entity.player.Player)this.entity);
        this.container.setTitle((Component)Component.literal((String)title));
        this.inventory = this.container.getBukkitView().getTopInventory();
    }

    @Override
    public void open_window(Player player) {
        if (this.tainted) {
            return;
        }
        if (Nms.player_handle(player) != this.entity) {
            ((Core)this.manager.get_module()).log.warning("AnvilMenu.open() was called with a player for whom this inventory wasn't created!");
        }
        this.entity.connection.send((Packet)new ClientboundOpenScreenPacket(this.container_id, this.container.getType(), (Component)Component.literal((String)this.title)));
        this.entity.initMenu((AbstractContainerMenu)this.container);
        this.entity.containerMenu = this.container;
    }

    private class AnvilContainer
    extends net.minecraft.world.inventory.AnvilMenu {
        public AnvilContainer(AnvilMenu anvilMenu, int window_id, net.minecraft.world.entity.player.Player entity) {
            super(window_id, entity.getInventory(), ContainerLevelAccess.create((Level)entity.level(), (BlockPos)new BlockPos(0, 0, 0)));
            this.checkReachable = false;
        }

        public void createResult() {
            super.createResult();
            this.cost.set(0);
        }

        public void removed(net.minecraft.world.entity.player.Player player) {
        }

        protected void clearContainer(net.minecraft.world.entity.player.Player player, Container container) {
        }
    }
}

