/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.functional.Function2;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.module.Context;

public interface Filter<T> {
    public void open_filter_settings(Context<?> var1, Player var2, String var3, Menu var4);

    public void reset();

    public List<T> filter(List<T> var1);

    public static class StringFilter<T>
    implements Filter<T> {
        private String str = null;
        private Function2<T, String, Boolean> do_filter;
        private boolean ignore_case;

        public StringFilter(Function2<T, String, Boolean> do_filter) {
            this(do_filter, true);
        }

        public StringFilter(Function2<T, String, Boolean> do_filter, boolean ignore_case) {
            this.do_filter = do_filter;
            this.ignore_case = ignore_case;
        }

        @Override
        public void open_filter_settings(Context<?> context, Player player, String filter_title, Menu return_to) {
            MenuFactory.anvil_string_input(context, player, filter_title, new ItemStack(Material.PAPER), "?", (p, menu, s) -> {
                menu.close((Player)p);
                this.str = s;
                return_to.open((Player)p);
                return Menu.ClickResult.SUCCESS;
            }).open(player);
        }

        @Override
        public void reset() {
            this.str = null;
        }

        @Override
        public List<T> filter(List<T> things) {
            if (this.str == null) {
                return things;
            }
            String f_str = this.ignore_case ? this.str.toLowerCase() : this.str;
            return things.stream().filter((? super T t) -> this.do_filter.apply(t, f_str)).collect(Collectors.toList());
        }
    }
}

