/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.functional.Consumer1;
import org.oddlama.vane.core.functional.Function1;
import org.oddlama.vane.core.functional.Function4;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuItem;
import org.oddlama.vane.core.menu.MenuManager;
import org.oddlama.vane.core.menu.MenuWidget;
import org.oddlama.vane.core.module.Context;
import org.oddlama.vane.core.module.Module;

public class GenericSelector<T, F extends Filter<T>> {
    private MenuManager menu_manager;
    private Function1<T, ItemStack> to_item;
    private Function4<Player, Menu, T, InventoryClickEvent, Menu.ClickResult> on_click;
    private List<T> things;
    private F filter;
    private int page_size;
    private boolean update_filter = true;
    private int page = 0;
    private int last_page = 0;
    private List<T> filtered_things = null;

    private GenericSelector() {
    }

    public static <T, F extends Filter<T>> Menu create(Context<?> context, Player player, String title, String filter_title, List<T> things, Function1<T, ItemStack> to_item, F filter, Function4<Player, Menu, T, InventoryClickEvent, Menu.ClickResult> on_click, Consumer1<Player> on_cancel) {
        int columns = 9;
        final GenericSelector<T, F> generic_selector = new GenericSelector<T, F>();
        generic_selector.menu_manager = ((Module)context.get_module()).core.menu_manager;
        generic_selector.to_item = to_item;
        generic_selector.on_click = on_click;
        generic_selector.things = things;
        generic_selector.filter = filter;
        generic_selector.page_size = 45;
        Menu generic_selector_menu = new Menu(context, Bukkit.createInventory(null, (int)54, (Component)LegacyComponentSerializer.legacySection().deserialize(title))){

            @Override
            public void update(boolean force_update) {
                if (generic_selector.update_filter) {
                    generic_selector.filtered_things = generic_selector.filter.filter(generic_selector.things);
                    generic_selector.page = 0;
                    generic_selector.last_page = Math.max(0, generic_selector.filtered_things.size() - 1) / generic_selector.page_size;
                    generic_selector.update_filter = false;
                }
                super.update(force_update);
            }
        };
        generic_selector_menu.add(new SelectionArea<T, F>(generic_selector, 0));
        generic_selector_menu.add(new PageSelector<T, F>(generic_selector, generic_selector.page_size + 1, generic_selector.page_size + 8));
        generic_selector_menu.add(new MenuItem(generic_selector.page_size, generic_selector.menu_manager.generic_selector_filter.item(new Object[0]), (p, menu, self, event) -> {
            if (!Menu.is_left_or_right_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            if (event.getClick() == ClickType.RIGHT) {
                generic_selector.filter.reset();
                generic_selector.update_filter = true;
                menu.update();
            } else {
                menu.close((Player)p);
                generic_selector.filter.open_filter_settings(context, (Player)p, filter_title, (Menu)menu);
                generic_selector.update_filter = true;
            }
            return Menu.ClickResult.SUCCESS;
        }));
        generic_selector_menu.add(new MenuItem(generic_selector.page_size + 8, generic_selector.menu_manager.generic_selector_cancel.item(new Object[0]), (p, menu, self) -> {
            menu.close((Player)p);
            on_cancel.apply(player);
            return Menu.ClickResult.SUCCESS;
        }));
        generic_selector_menu.on_natural_close(on_cancel);
        return generic_selector_menu;
    }

    public static class SelectionArea<T, F extends Filter<T>>
    implements MenuWidget {
        private final GenericSelector<T, F> generic_selector;
        private final int first_slot;

        public SelectionArea(GenericSelector<T, F> generic_selector, int first_slot) {
            this.generic_selector = generic_selector;
            this.first_slot = first_slot;
        }

        @Override
        public boolean update(Menu menu) {
            for (int i = 0; i < this.generic_selector.page_size; ++i) {
                int idx = this.generic_selector.page * this.generic_selector.page_size + i;
                if (idx >= this.generic_selector.filtered_things.size()) {
                    menu.inventory().setItem(this.first_slot + i, null);
                    continue;
                }
                menu.inventory().setItem(this.first_slot + i, this.generic_selector.to_item.apply(this.generic_selector.filtered_things.get(idx)));
            }
            return true;
        }

        @Override
        public Menu.ClickResult click(Player player, Menu menu, ItemStack item, int slot, InventoryClickEvent event) {
            if (slot < this.first_slot || slot >= this.first_slot + this.generic_selector.page_size) {
                return Menu.ClickResult.IGNORE;
            }
            if (menu.inventory().getItem(slot) == null) {
                return Menu.ClickResult.IGNORE;
            }
            int idx = this.generic_selector.page * this.generic_selector.page_size + (slot - this.first_slot);
            return this.generic_selector.on_click.apply(player, menu, this.generic_selector.filtered_things.get(idx), event);
        }
    }

    public static class PageSelector<T, F extends Filter<T>>
    implements MenuWidget {
        private static final int BIG_JUMP_SIZE = 5;
        private final GenericSelector<T, F> generic_selector;
        private final int slot_from;
        private final int slot_to;

        public PageSelector(GenericSelector<T, F> generic_selector, int slot_from, int slot_to) {
            this.generic_selector = generic_selector;
            this.slot_from = slot_from;
            this.slot_to = slot_to;
            if (this.slot_to - this.slot_from < 3) {
                throw new IllegalArgumentException("PageSelector needs at least 3 assigned slots!");
            }
            if ((this.slot_to - this.slot_from) % 2 == 0) {
                throw new IllegalArgumentException("PageSelector needs an uneven number of assigned slots!");
            }
        }

        @Override
        public boolean update(Menu menu) {
            for (int slot = this.slot_from; slot < this.slot_to; ++slot) {
                int i = slot - this.slot_from;
                int offset = this.button_offset(i);
                int page = this.page_for_offset(offset);
                boolean no_op = page == this.generic_selector.page;
                int actual_offset = page - this.generic_selector.page;
                ItemStack item = i == (this.slot_to - this.slot_from) / 2 ? this.generic_selector.menu_manager.generic_selector_current_page.item("\u00a76" + (page + 1), "\u00a76" + (this.generic_selector.last_page + 1), "\u00a76" + this.generic_selector.filtered_things.size()) : (no_op ? null : this.generic_selector.menu_manager.generic_selector_page.item_amount(Math.abs(actual_offset), "\u00a76" + (page + 1)));
                menu.inventory().setItem(slot, item);
            }
            return true;
        }

        private int button_offset(int i) {
            if (i <= 0) {
                return -5;
            }
            if (i >= this.slot_to - this.slot_from - 1) {
                return 5;
            }
            int base = (this.slot_to - this.slot_from) / 2;
            return i - base;
        }

        private int page_for_offset(int offset) {
            int page = this.generic_selector.page + offset;
            if (page < 0) {
                page = 0;
            } else if (page > this.generic_selector.last_page) {
                page = this.generic_selector.last_page;
            }
            return page;
        }

        @Override
        public Menu.ClickResult click(Player player, Menu menu, ItemStack item, int slot, InventoryClickEvent event) {
            if (slot < this.slot_from || slot >= this.slot_to) {
                return Menu.ClickResult.IGNORE;
            }
            if (menu.inventory().getItem(slot) == null) {
                return Menu.ClickResult.IGNORE;
            }
            if (!Menu.is_left_click(event)) {
                return Menu.ClickResult.INVALID_CLICK;
            }
            int offset = this.button_offset(slot - this.slot_from);
            this.generic_selector.page = this.page_for_offset(offset);
            menu.update();
            return Menu.ClickResult.SUCCESS;
        }
    }
}

