/*
 * Decompiled with CFR 0.152.
 */
package org.oddlama.vane.core.menu;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.oddlama.vane.core.material.HeadMaterial;
import org.oddlama.vane.core.menu.Filter;
import org.oddlama.vane.core.menu.Menu;
import org.oddlama.vane.core.menu.MenuFactory;
import org.oddlama.vane.core.module.Context;

public class HeadFilter
implements Filter<HeadMaterial> {
    private String str = null;

    @Override
    public void open_filter_settings(Context<?> context, Player player, String filter_title, Menu return_to) {
        MenuFactory.anvil_string_input(context, player, filter_title, new ItemStack(Material.PAPER), "?", (p, menu, s) -> {
            menu.close((Player)p);
            this.str = s.toLowerCase();
            return_to.open((Player)p);
            return Menu.ClickResult.SUCCESS;
        }).open(player);
    }

    @Override
    public void reset() {
        this.str = null;
    }

    private boolean filter_by_categories(HeadMaterial material) {
        return material.category().toLowerCase().contains(this.str);
    }

    private boolean filter_by_tags(HeadMaterial material) {
        for (String tag : material.tags()) {
            if (!tag.toLowerCase().contains(this.str)) continue;
            return true;
        }
        return false;
    }

    private boolean filter_by_name(HeadMaterial material) {
        return material.name().toLowerCase().contains(this.str);
    }

    @Override
    public List<HeadMaterial> filter(List<HeadMaterial> things) {
        if (this.str == null) {
            return things;
        }
        return things.stream().filter((? super T t) -> this.filter_by_categories((HeadMaterial)t) || this.filter_by_tags((HeadMaterial)t) || this.filter_by_name((HeadMaterial)t)).collect(Collectors.toList());
    }
}

